/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.component;

import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.component.GateComponent;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.transform.Translation;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class GateComponentLever
extends GateComponent {
    private boolean state = false;
    private int layoutColor = -1;
    protected double x = 0.0;
    protected double z = 0.0;

    public GateComponentLever(GateBase<?, ?, ?, ?, ?, ?> gate, int color) {
        super(gate);
        this.layoutColor = color;
        this.onLayoutRefresh();
    }

    public GateComponentLever(GateBase<?, ?, ?, ?, ?, ?> gate, double x, double z) {
        super(gate);
        this.x = x;
        this.z = z;
    }

    @Override
    public void renderStatic(Vec3i translation, RenderHelper renderer, int pass) {
        renderer.addTransformation((Transformation)new Translation(this.x, 0.0, this.z));
        renderer.renderBox(new Vec3dCube(0.0, 0.125, 0.0, 0.25, 0.25, 0.4375), Blocks.field_150347_e.func_149691_a(0, 0));
        renderer.removeTransformation();
    }

    @Override
    public void renderDynamic(Vec3d translation, double delta, int pass) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        Tessellator t = Tessellator.field_78398_a;
        IIcon icon = Blocks.field_150442_at.func_149691_a(0, 0);
        double minU = icon.func_94209_e();
        double minV = icon.func_94206_g();
        double maxU = icon.func_94212_f();
        double maxV = icon.func_94210_h();
        GL11.glTranslated((double)(-this.x + 0.375), (double)0.125, (double)(-this.z + 0.71875));
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.0625);
        GL11.glRotated((double)(this.state ? 40.0 : -40.0), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.0625);
        t.func_78382_b();
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        t.func_78374_a(0.0, 0.0, 0.0, minU, maxV);
        t.func_78374_a(0.0, 0.75, 0.0, minU, minV);
        t.func_78374_a(1.0, 0.75, 0.0, maxU, minV);
        t.func_78374_a(1.0, 0.0, 0.0, maxU, maxV);
        t.func_78372_c(0.0f, 0.0f, 0.125f);
        t.func_78374_a(0.0, 0.0, 0.0, maxU, maxV);
        t.func_78374_a(1.0, 0.0, 0.0, minU, maxV);
        t.func_78374_a(1.0, 0.75, 0.0, minU, minV);
        t.func_78374_a(0.0, 0.75, 0.0, maxU, minV);
        t.func_78372_c(0.0f, 0.0f, -0.125f);
        t.func_78372_c(0.4375f, 0.0f, -0.4375f);
        t.func_78374_a(0.0, 0.0, 0.0, maxU, maxV);
        t.func_78374_a(0.0, 0.0, 1.0, minU, maxV);
        t.func_78374_a(0.0, 0.75, 1.0, minU, minV);
        t.func_78374_a(0.0, 0.75, 0.0, maxU, minV);
        t.func_78372_c(-0.4375f, 0.0f, 0.4375f);
        t.func_78372_c(0.5625f, 0.0f, -0.4375f);
        t.func_78374_a(0.0, 0.0, 0.0, minU, maxV);
        t.func_78374_a(0.0, 0.75, 0.0, minU, minV);
        t.func_78374_a(0.0, 0.75, 1.0, maxU, minV);
        t.func_78374_a(0.0, 0.0, 1.0, maxU, maxV);
        t.func_78372_c(-0.5625f, 0.0f, 0.4375f);
        t.func_78372_c(0.4375f, 0.0f, 0.0f);
        minU = icon.func_94214_a(7.0);
        maxU = icon.func_94214_a(9.0);
        minV = icon.func_94207_b(6.0);
        maxV = icon.func_94207_b(8.0);
        t.func_78374_a(0.0, 0.46875, 0.0, minU, maxV);
        t.func_78374_a(0.0, 0.46875, 0.125, minU, minV);
        t.func_78374_a(0.125, 0.46875, 0.125, maxU, minV);
        t.func_78374_a(0.125, 0.46875, 0.0, maxU, maxV);
        t.func_78372_c(-0.4375f, 0.0f, 0.0f);
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    @Override
    public void onLayoutRefresh() {
        if (this.layoutColor == -1) {
            return;
        }
        BufferedImage img = ((GateBase)this.getGate()).getLayout().getLayout(this.layoutColor);
        this.x = img.getWidth();
        this.z = img.getHeight();
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getWidth(); ++y) {
                if ((img.getRGB(x, y) & 0xFFFFFF) == 0) continue;
                this.x = Math.min(this.x, (double)x);
                this.z = Math.min(this.z, (double)y);
            }
        }
        this.x /= (double)img.getWidth();
        this.z /= (double)img.getHeight();
    }

    public GateComponentLever setState(boolean state) {
        this.state = state;
        return this;
    }

    public boolean getState() {
        return this.state;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("state", this.state);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.state = tag.func_74767_n("state");
    }

    @Override
    public void writeData(DataOutput buffer) throws IOException {
        super.writeData(buffer);
        buffer.writeBoolean(this.state);
    }

    @Override
    public void readData(DataInput buffer) throws IOException {
        super.readData(buffer);
        this.state = buffer.readBoolean();
    }
}

