/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.worldgen;

import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.item.Item;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStoneOre
extends Block {
    private String name;
    private boolean transparent = false;
    private boolean witherproof = false;
    private String[] tooltip = new String[0];

    public BlockStoneOre(String name) {
        super(Material.field_151576_e);
        this.name = name;
        this.func_149752_b(5.0f);
        this.func_149711_c(4.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149663_c(name);
        this.func_149647_a(BPCreativeTabs.blocks);
        this.func_149672_a(field_149769_e);
    }

    public Block setToolLevel(int level) {
        super.setHarvestLevel("pickaxe", level);
        return this;
    }

    public String func_149739_a() {
        return String.format("tile.bluepower:" + this.name, new Object[0]);
    }

    public Item func_149650_a(int par1, Random par2, int par3) {
        return Item.func_150898_a((Block)Block.func_149684_b((String)("bluepower:" + this.name)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("bluepower:" + this.name);
    }

    public boolean isBeaconBase(IBlockAccess worldObj, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        return this == BPBlocks.amethyst_block || this == BPBlocks.ruby_block || this == BPBlocks.sapphire_block || this == BPBlocks.copper_block || this == BPBlocks.zinc_block || this == BPBlocks.silver_block || this == BPBlocks.tungsten_block;
    }

    public BlockStoneOre setTransparent(boolean transparent) {
        this.transparent = transparent;
        return this;
    }

    public boolean func_149721_r() {
        return !this.transparent;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149637_q() {
        return !this.transparent;
    }

    public boolean func_149662_c() {
        return !this.transparent;
    }

    public boolean func_149686_d() {
        return !this.transparent;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInPass(int pass) {
        return this.transparent ? true : super.canRenderInPass(pass);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.transparent ? 1 : super.func_149701_w();
    }

    public boolean func_149646_a(IBlockAccess w, int x, int y, int z, int p_149646_5_) {
        if (this.transparent) {
            return w.func_147439_a(x, y, z) != this;
        }
        return super.func_149646_a(w, x, y, z, p_149646_5_);
    }

    public int func_149717_k() {
        return this.transparent ? 0 : super.func_149717_k();
    }

    public BlockStoneOre setWitherproof(boolean witherproof) {
        this.witherproof = witherproof;
        return this;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        if (this.witherproof) {
            return !(entity instanceof EntityWither) && super.canEntityDestroy(world, x, y, z, entity);
        }
        return super.canEntityDestroy(world, x, y, z, entity);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (!this.witherproof) {
            super.onBlockExploded(world, x, y, z, explosion);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return this.witherproof ? false : super.func_149659_a(explosion);
    }

    public BlockStoneOre setTooltip(String ... tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public String[] getTooltip() {
        return this.tooltip;
    }
}

