/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.renderer;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.MultiBlock;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.door.block.RustyHatch;
import net.malisis.doors.door.tileentity.RustyHatchTileEntity;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class RustyHatchRenderer
extends MalisisRenderer {
    private ResourceLocation rl;
    private MalisisModel model;
    private Shape frame;
    private Shape hatch;
    private Shape handle;
    private Shape ladder;
    private AnimationRenderer ar = new AnimationRenderer();
    private RustyHatchTileEntity tileEntity;
    private boolean topBlock;
    private ForgeDirection direction;

    public RustyHatchRenderer() {
        this.getBlockDamage = true;
    }

    protected void initialize() {
        this.rl = new ResourceLocation("malisisdoors", "models/rustyhatch.obj");
        this.model = new MalisisModel(this.rl);
        this.frame = this.model.getShape("frame");
        this.hatch = this.model.getShape("door");
        this.handle = this.model.getShape("handle");
        this.ladder = this.model.getShape("ladder");
        this.rp = new RenderParameters();
        this.rp.useBlockBounds.set((Object)false);
    }

    public void render() {
        if (this.block == MalisisDoors.Blocks.rustyLadder) {
            this.ladder.resetState();
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.blockMetadata);
            switch (dir) {
                case NORTH: {
                    this.ladder.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
                    break;
                }
                case SOUTH: {
                    this.ladder.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                    break;
                }
                case EAST: {
                    this.ladder.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                    break;
                }
            }
            this.ladder.translate(-1.0f, 0.0f, 0.0f);
            this.drawShape(this.ladder, this.rp);
            return;
        }
        if (this.renderType == RenderType.ITEM_INVENTORY) {
            this.renderItem();
            return;
        }
        this.tileEntity = (RustyHatchTileEntity)MultiBlock.getOriginProvider(RustyHatchTileEntity.class, (IBlockAccess)this.world, (int)this.x, (int)this.y, (int)this.z);
        if (this.tileEntity == null) {
            return;
        }
        this.topBlock = this.tileEntity.isTopBlock(this.x, this.y, this.z);
        this.direction = ForgeDirection.getOrientation((int)this.tileEntity.getDirection());
        if (this.renderType == RenderType.ISBRH_WORLD) {
            this.getBlockDamage = true;
            this.renderBlock();
        } else if (this.renderType == RenderType.TESR_WORLD) {
            this.renderTileEntity();
        }
    }

    private void renderBlock() {
        if (!MultiBlock.isOrigin((IBlockAccess)this.world, (int)this.x, (int)this.y, (int)this.z)) {
            if (!this.tileEntity.shouldLadder(this.x, this.y, this.z)) {
                return;
            }
            if (this.ladder == null) {
                return;
            }
            this.ladder.resetState();
            this.ladder.translate((float)this.direction.getOpposite().offsetX, this.topBlock ? -1.0f : 0.0f, (float)this.direction.getOpposite().offsetZ);
            this.setup(this.ladder);
            this.rp.icon.set((Object)((RustyHatch)this.block).getHandleIcon());
            this.drawShape(this.ladder, this.rp);
        } else {
            if (this.frame == null) {
                return;
            }
            this.frame.resetState();
            this.setup(this.frame);
            this.rp.icon.set((Object)Blocks.field_150460_al.func_149691_a(1, 0));
            this.drawShape(this.frame, this.rp);
        }
    }

    private void renderTileEntity() {
        if (!MultiBlock.isOrigin((IBlockAccess)this.world, (int)this.x, (int)this.y, (int)this.z)) {
            return;
        }
        if (this.hatch == null || this.handle == null) {
            return;
        }
        this.tileEntity = (RustyHatchTileEntity)((MalisisRenderer)this).tileEntity;
        this.hatch.resetState();
        this.handle.resetState();
        this.setup(this.hatch);
        this.setup(this.handle);
        this.ar.setStartTime(this.tileEntity.getTimer().getStart());
        if (this.tileEntity.getMovement() != null) {
            Animation[] anims = this.tileEntity.getMovement().getAnimations(this.tileEntity, this.model, this.rp);
            this.ar.animate(anims);
        }
        this.next(9);
        this.rp.icon.reset();
        this.drawShape(this.hatch, this.rp);
        this.rp.icon.set((Object)((RustyHatch)this.block).getHandleIcon());
        this.drawShape(this.handle, this.rp);
    }

    private void renderItem() {
        this.func_147499_a(TextureMap.field_110575_b);
        this.handle.resetState();
        this.handle.scale(1.5f);
        switch (this.itemRenderType) {
            case INVENTORY: {
                this.handle.translate(0.2f, 0.0f, 0.15f);
                this.handle.rotate(90.0f, 0.0f, 0.0f, 1.0f);
                break;
            }
            case EQUIPPED: {
                this.handle.translate(-0.5f, -0.75f, 0.0f);
                this.handle.rotate(100.0f, 0.0f, 0.0f, 1.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.handle.translate(0.0f, -0.1f, -0.2f);
                this.handle.rotate(90.0f, 0.0f, 0.0f, 1.0f);
            }
        }
        this.rp.icon.set((Object)MalisisDoors.Blocks.rustyHatch.getHandleIcon());
        this.drawShape(this.handle, this.rp);
    }

    private void setup(Shape s) {
        if (this.topBlock) {
            s.translate(0.0f, 0.875f, 0.0f);
        }
        if (this.direction == ForgeDirection.SOUTH) {
            s.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
        } else if (this.direction == ForgeDirection.NORTH) {
            s.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        } else if (this.direction == ForgeDirection.WEST) {
            s.rotate(180.0f, 0.0f, 1.0f, 0.0f);
        }
    }

    protected boolean isCurrentBlockDestroyProgress(DestroyBlockProgress dbp) {
        if (!(this.world.func_147438_o(dbp.func_73110_b(), dbp.func_73109_c(), dbp.func_73108_d()) instanceof RustyHatchTileEntity)) {
            return false;
        }
        MultiBlock mb = MultiBlock.getMultiBlock((IBlockAccess)this.world, (int)dbp.func_73110_b(), (int)dbp.func_73109_c(), (int)dbp.func_73108_d());
        return mb != null && mb.getX() == this.tileEntity.getMultiBlock().getX() && mb.getY() == this.tileEntity.getMultiBlock().getY() && mb.getZ() == this.tileEntity.getMultiBlock().getZ();
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }
}

