/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.renderer;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.client.renderer.DestroyBlockProgress;

public class DoorRenderer
extends MalisisRenderer {
    protected DoorTileEntity tileEntity;
    protected MalisisModel model;
    protected int direction;
    protected boolean opened;
    protected boolean reversed;
    protected boolean topBlock;
    protected Shape shape;
    protected RenderParameters rp;
    protected AnimationRenderer ar = new AnimationRenderer();

    public DoorRenderer() {
        this.getBlockDamage = true;
    }

    protected void initialize() {
        Cube bottom = new Cube();
        bottom.setSize(1.0f, 1.0f, 0.1875f);
        bottom.scale(1.0f, 1.0f, 0.995f);
        Shape top = new Shape((Shape)bottom);
        top.translate(0.0f, 1.0f, 0.0f);
        this.shape = bottom;
        this.model = new MalisisModel();
        this.model.addShape("bottom", (Shape)bottom);
        this.model.addShape("top", top);
        this.model.storeState();
        this.initParams();
    }

    protected void initParams() {
        this.rp = new RenderParameters();
        this.rp.renderAllFaces.set((Object)true);
        this.rp.calculateAOColor.set((Object)false);
        this.rp.useBlockBounds.set((Object)false);
        this.rp.useBlockBrightness.set((Object)false);
        this.rp.calculateBrightness.set((Object)false);
        this.rp.interpolateUV.set((Object)false);
    }

    public void render() {
        if (this.renderType == RenderType.ISBRH_WORLD) {
            return;
        }
        this.setTileEntity();
        this.direction = this.tileEntity.getDirection();
        this.opened = this.tileEntity.isOpened();
        this.reversed = this.tileEntity.isReversed();
        this.topBlock = this.tileEntity.isTopBlock(this.x, this.y, this.z);
        this.rp.icon.set(null);
        this.renderTileEntity();
    }

    protected void setTileEntity() {
        this.tileEntity = (DoorTileEntity)((MalisisRenderer)this).tileEntity;
    }

    protected void setup() {
        this.model.resetState();
        if (this.direction == 3) {
            this.model.rotate(180.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (this.direction == 2) {
            this.model.rotate(-90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (this.direction == 0) {
            this.model.rotate(90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    protected void renderTileEntity() {
        this.enableBlending();
        this.ar.setStartTime(this.tileEntity.getTimer().getStart());
        this.initialize();
        this.setup();
        if (this.tileEntity.getMovement() != null) {
            Animation[] anims = this.tileEntity.getMovement().getAnimations(this.tileEntity, this.model, this.rp);
            this.ar.animate(anims);
        }
        this.rp.brightness.set((Object)this.block.func_149677_c(this.world, this.x, this.y, this.z));
        this.drawShape(this.model.getShape("bottom"), this.rp);
        this.blockMetadata |= 8;
        ++this.y;
        this.rp.brightness.set((Object)this.block.func_149677_c(this.world, this.x, this.y, this.z));
        this.drawShape(this.model.getShape("top"), this.rp);
        --this.y;
    }

    protected boolean isCurrentBlockDestroyProgress(DestroyBlockProgress dbp) {
        return dbp.func_73110_b() == this.x && (dbp.func_73109_c() == this.y || dbp.func_73109_c() == this.y + 1) && dbp.func_73108_d() == this.z;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }
}

