/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ChainedTransformation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class RotateAndPlaceMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity te, boolean topBlock, BoundingBoxType type) {
        int dir = te.getDirection();
        boolean opened = te.isOpened();
        boolean reversed = te.isReversed();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (dir == 1 && !opened || dir == 0 && opened && !reversed || dir == 2 && opened && reversed) {
            Z = 0.1875f;
        } else if (dir == 0 && !opened || dir == 3 && opened && !reversed || dir == 1 && opened && reversed) {
            X = 0.1875f;
        } else if (dir == 2 && !opened || dir == 1 && opened && !reversed || dir == 3 && opened && reversed) {
            x = 0.8125f;
        } else if (dir == 3 && !opened || dir == 2 && opened && !reversed || dir == 0 && opened && reversed) {
            z = 0.8125f;
        }
        if (opened) {
            if (dir == 1) {
                z -= 0.5f;
                Z -= 0.5f;
            } else if (dir == 3) {
                z += 0.5f;
                Z += 0.5f;
            } else if (dir == 2) {
                x += 0.5f;
                X += 0.5f;
            } else if (dir == 0) {
                x -= 0.5f;
                X -= 0.5f;
            }
        }
        if (type == BoundingBoxType.SELECTION) {
            if (!topBlock) {
                Y += 1.0f;
            } else {
                y -= 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    private Transformation getTransformation(DoorTileEntity tileEntity) {
        int ot = tileEntity.getDescriptor().getOpeningTime() / 2;
        float angle = 90.0f;
        float hinge = 0.0f;
        float hingeZ = -0.5f;
        float trX = -0.5f;
        float trZ = 0.3125f;
        if (tileEntity.isReversed()) {
            hinge = -hinge;
            angle = -angle;
            trX = -trX;
        }
        Transformation rotation = new Rotation(angle).aroundAxis(0.0f, 1.0f, 0.0f).offset(hinge, 0.0f, hingeZ).forTicks(ot);
        Transformation translation = new Translation(0.0f, 0.0f, trZ).forTicks(ot);
        ChainedTransformation transformation = new ChainedTransformation(new Transformation[]{rotation, translation});
        transformation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        return transformation;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model, this.getTransformation(tileEntity))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

