/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import micdoodle8.mods.galacticraft.api.block.IOxygenReliantBlock;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.entities.EntityBubble;
import micdoodle8.mods.galacticraft.core.entities.IBubble;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProvider;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityOxygenDistributor
extends TileEntityOxygen
implements IInventory,
ISidedInventory,
IBubbleProvider {
    public boolean active;
    public boolean lastActive;
    private ItemStack[] containingItems = new ItemStack[2];
    public EntityBubble oxygenBubble = null;
    public static ArrayList<BlockVec3Dim> loadedTiles = Lists.newArrayList();
    private boolean hasValidBubble;

    public TileEntityOxygenDistributor() {
        super(6000.0f, 8.0f);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.add(new BlockVec3Dim(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g));
        }
    }

    @Override
    public void onChunkUnload() {
        Iterator<BlockVec3Dim> i = loadedTiles.iterator();
        while (i.hasNext()) {
            BlockVec3Dim vec = i.next();
            if (vec.dim != this.field_145850_b.field_73011_w.field_76574_g || this.field_145851_c != vec.x || this.field_145848_d != vec.y || this.field_145849_e != vec.z) continue;
            i.remove();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.oxygenBubble != null) {
            double size = this.oxygenBubble.getSize();
            int bubbleR = MathHelper.func_76143_f((double)size);
            int bubbleR2 = (int)(size * size);
            for (int x = this.field_145851_c - bubbleR; x < this.field_145851_c + bubbleR; ++x) {
                for (int y = this.field_145848_d - bubbleR; y < this.field_145848_d + bubbleR; ++y) {
                    for (int z = this.field_145849_e - bubbleR; z < this.field_145849_e + bubbleR; ++z) {
                        Block block = this.field_145850_b.func_147439_a(x, y, z);
                        if (!(block instanceof IOxygenReliantBlock) || this.getDistanceFromServer(x, y, z) > bubbleR2) continue;
                        this.field_145850_b.func_147454_a(x, y, z, block, 1, 0);
                    }
                }
            }
            this.oxygenBubble.func_70106_y();
        }
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.remove(this);
        }
        super.func_145843_s();
    }

    @Override
    public void addExtraNetworkedData(List<Object> networkedList) {
        if (!this.field_145850_b.field_72995_K) {
            networkedList.add(this.oxygenBubble != null);
            if (this.oxygenBubble != null) {
                networkedList.add(this.oxygenBubble.func_145782_y());
            }
            networkedList.add(loadedTiles.size());
            for (BlockVec3Dim distributor : new ArrayList<BlockVec3Dim>(loadedTiles)) {
                networkedList.add(distributor.x);
                networkedList.add(distributor.y);
                networkedList.add(distributor.z);
                networkedList.add(distributor.dim);
            }
        }
    }

    @Override
    public void readExtraNetworkedData(ByteBuf dataStream) {
        loadedTiles.clear();
        if (this.field_145850_b.field_72995_K) {
            if (dataStream.readBoolean()) {
                this.oxygenBubble = (EntityBubble)this.field_145850_b.func_73045_a(dataStream.readInt());
            }
            int size = dataStream.readInt();
            for (int i = 0; i < size; ++i) {
                loadedTiles.add(new BlockVec3Dim(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt()));
            }
        }
    }

    public int getDistanceFromServer(int par1, int par3, int par5) {
        int d3 = this.field_145851_c - par1;
        int d4 = this.field_145848_d - par3;
        int d5 = this.field_145849_e - par5;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    @Override
    public void func_145845_h() {
        ItemStack oxygenItemStack;
        if (!this.field_145850_b.field_72995_K && (oxygenItemStack = this.func_70301_a(1)) != null && oxygenItemStack.func_77973_b() instanceof IItemOxygenSupply) {
            IItemOxygenSupply oxygenItem = (IItemOxygenSupply)oxygenItemStack.func_77973_b();
            float oxygenDraw = Math.min(this.oxygenPerTick * 2.5f, this.maxOxygen - this.storedOxygen);
            this.storedOxygen += oxygenItem.discharge(oxygenItemStack, oxygenDraw);
            if (this.storedOxygen > this.maxOxygen) {
                this.storedOxygen = this.maxOxygen;
            }
        }
        super.func_145845_h();
        if (!(this.hasValidBubble || this.field_145850_b.field_72995_K || this.oxygenBubble != null && this.ticks >= 25L || this.oxygenBubble != null || !(this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider) || ((IGalacticraftWorldProvider)this.field_145850_b.field_73011_w).hasBreathableAtmosphere())) {
            this.oxygenBubble = new EntityBubble(this.field_145850_b, new Vector3(this), this);
            this.hasValidBubble = true;
            this.field_145850_b.func_72838_d((Entity)this.oxygenBubble);
        }
        if (!this.field_145850_b.field_72995_K && this.oxygenBubble != null) {
            this.active = this.oxygenBubble.getSize() >= 1.0f && this.hasEnoughEnergyToRun && this.storedOxygen > this.oxygenPerTick;
            if (this.ticks % (long)(this.active ? 20 : 4) == 0L) {
                double size = this.oxygenBubble.getSize();
                int bubbleR = MathHelper.func_76128_c((double)size) + 4;
                int bubbleR2 = (int)(size * size);
                for (int x = this.field_145851_c - bubbleR; x <= this.field_145851_c + bubbleR; ++x) {
                    for (int y = this.field_145848_d - bubbleR; y <= this.field_145848_d + bubbleR; ++y) {
                        for (int z = this.field_145849_e - bubbleR; z <= this.field_145849_e + bubbleR; ++z) {
                            Block block = this.field_145850_b.func_147439_a(x, y, z);
                            if (!(block instanceof IOxygenReliantBlock)) continue;
                            if (this.getDistanceFromServer(x, y, z) <= bubbleR2) {
                                ((IOxygenReliantBlock)block).onOxygenAdded(this.field_145850_b, x, y, z);
                                continue;
                            }
                            this.field_145850_b.func_147454_a(x, y, z, block, 1, 0);
                        }
                    }
                }
            }
        }
        this.lastActive = this.active;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hasValidBubble = nbt.func_74767_n("hasValidBubble");
        NBTTagList var2 = nbt.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("hasValidBubble", this.hasValidBubble);
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.oxygendistributor.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return itemstack.func_77973_b() instanceof ItemElectricBase && ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) > 0.0f;
                }
                case 1: {
                    return itemstack.func_77960_j() < itemstack.func_77973_b().func_77612_l();
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        switch (slotID) {
            case 0: {
                return itemstack.func_77973_b() instanceof ItemElectricBase && ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f;
            }
            case 1: {
                return FluidUtil.isEmptyContainer(itemstack);
            }
        }
        return false;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (slotID == 0) {
            return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IItemOxygenSupply;
        }
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.storedOxygen > this.oxygenPerTick;
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() + 2));
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public boolean shouldUseOxygen() {
        return this.hasEnoughEnergyToRun;
    }

    @Override
    public EnumSet<ForgeDirection> getOxygenInputDirections() {
        return EnumSet.of(this.getElectricInputDirection().getOpposite());
    }

    @Override
    public EnumSet<ForgeDirection> getOxygenOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public IBubble getBubble() {
        return this.oxygenBubble;
    }

    public boolean inBubble(double pX, double pY, double pZ) {
        if (this.oxygenBubble != null) {
            double r = this.oxygenBubble.getSize();
            r *= r;
            double d3 = (double)this.field_145851_c + 0.5 - pX;
            if ((d3 *= d3) > r) {
                return false;
            }
            double d4 = (double)this.field_145849_e + 0.5 - pZ;
            if (d3 + (d4 *= d4) > r) {
                return false;
            }
            double d5 = (double)this.field_145848_d + 0.5 - pY;
            return d3 + d4 + d5 * d5 < r;
        }
        return false;
    }

    @Override
    public void setBubbleVisible(boolean shouldRender) {
        if (this.oxygenBubble == null) {
            return;
        }
        this.oxygenBubble.setShouldRender(shouldRender);
    }
}

