/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockFluidGC
extends BlockFluidClassic {
    private IIcon stillIcon;
    private IIcon flowingIcon;
    private final String fluidName;
    private final Fluid fluid;

    public BlockFluidGC(Fluid fluid, String assetName) {
        super(fluid, assetName.equals("oil") || assetName.equals("fuel") ? GalacticraftCore.materialOil : Material.field_151586_h);
        this.setRenderPass(1);
        this.fluidName = assetName;
        this.fluid = fluid;
        if (assetName.equals("oil")) {
            this.field_149789_z = true;
        }
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return par1 != 0 && par1 != 1 ? this.flowingIcon : this.stillIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.stillIcon = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + this.fluidName + "_still");
        this.flowingIcon = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + this.fluidName + "_flow");
        this.fluid.setStillIcon(this.stillIcon);
        this.fluid.setFlowingIcon(this.flowingIcon);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K && this.fluidName.equals("oil") && entityPlayer instanceof EntityPlayerSP) {
            ClientProxyCore.playerClientHandler.onBuild(7, (EntityPlayerSP)entityPlayer);
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        super.func_149734_b(world, x, y, z, rand);
        if (this.fluidName.equals("oil") && rand.nextInt(1200) == 0) {
            world.func_72980_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "liquid.lava", rand.nextFloat() * 0.25f + 0.75f, 1.0E-5f + rand.nextFloat() * 0.5f, false);
        }
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) instanceof BlockLiquid) {
            int meta = world.func_72805_g(x, y, z);
            return meta > 1 || meta == -1;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) instanceof BlockLiquid) {
            int meta = world.func_72805_g(x, y, z);
            if (meta > 1 || meta == -1) {
                return super.displaceIfPossible(world, x, y, z);
            }
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    public IIcon getStillIcon() {
        return this.stillIcon;
    }

    public IIcon getFlowingIcon() {
        return this.flowingIcon;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (!(world instanceof World)) {
            return false;
        }
        if (OxygenUtil.noAtmosphericCombustion(((World)world).field_73011_w) && !OxygenUtil.isAABBInBreathableAirBlock((World)world, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1)))) {
            return false;
        }
        if (this.fluidName.startsWith("fuel")) {
            ((World)world).func_72876_a(null, (double)x, (double)y, (double)z, 6.0f, true);
            return true;
        }
        return this.fluidName.startsWith("oil");
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return super.func_149646_a(world, x, y, z, side);
    }
}

