/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.util;

import java.util.Random;
import latmod.core.util.MathHelperLM;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;

public final class Vertex
implements Cloneable {
    public double x;
    public double y;
    public double z;

    public Vertex() {
    }

    public Vertex(double nx, double ny, double nz) {
        this.x = nx;
        this.y = ny;
        this.z = nz;
    }

    public Vertex(Entity e, boolean y) {
        this(e.field_70165_t, y ? e.field_70163_u : 0.0, e.field_70161_v);
    }

    public Vertex(Entity e) {
        this(e, true);
    }

    public Vertex(ChunkCoordinates c, boolean y) {
        this((double)c.field_71574_a + 0.5, (y ? (double)c.field_71572_b : 0.0) + 0.5, (double)c.field_71573_c + 0.5);
    }

    public Vertex(ChunkCoordinates c) {
        this(c, true);
    }

    public Vertex(Random r, boolean sin) {
        this(r.nextDouble(), r.nextDouble(), r.nextDouble());
        if (sin) {
            this.scale(2.0);
            this.add(-1.0, -1.0, -1.0);
        }
    }

    public void set(double nx, double ny, double nz) {
        this.x = nx;
        this.y = ny;
        this.z = nz;
    }

    public void set(Vertex v) {
        this.set(v.x, v.y, v.z);
    }

    public void add(double ax, double ay, double az) {
        this.set(this.x + ax, this.y + ay, this.z + az);
    }

    public void add(Vertex v, double s) {
        this.add(v.x * s, v.y * s, v.z * s);
    }

    public void scale(double sx, double sy, double sz) {
        this.x *= sx;
        this.y *= sy;
        this.z *= sz;
    }

    public void scale(Vertex v, double s) {
        this.scale(v.x * s, v.y * s, v.z * s);
    }

    public void scale(double s) {
        this.scale(s, s, s);
    }

    public boolean isNull() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public boolean containsNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.y);
    }

    public boolean equals(Object o) {
        return o instanceof Vertex && this.equalsPos((Vertex)o);
    }

    public boolean equalsPos(Vertex v) {
        return v.x == this.x && v.y == this.y && v.z == this.z;
    }

    public Vertex clone() {
        return new Vertex(this.x, this.y, this.z);
    }

    public double distSq(double x1, double y1, double z1) {
        return MathHelperLM.sq(x1 - this.x) + MathHelperLM.sq(y1 - this.y) + MathHelperLM.sq(z1 - this.z);
    }

    public double dist(double x1, double y1, double z1) {
        return MathHelperLM.sqrt(this.distSq(x1, y1, z1));
    }

    public double distSq(Vertex v) {
        return this.distSq(v.x, v.y, v.z);
    }

    public double dist(Vertex v) {
        return MathHelperLM.sqrt(this.distSq(v));
    }

    public double atan2(Vertex v) {
        if (v == null) {
            return -1.0;
        }
        return Math.atan2(this.x - v.x, this.z - v.z);
    }

    public double atan2Y(Vertex v) {
        if (v == null) {
            return -1.0;
        }
        return Math.atan2(this.x - v.x, this.y - v.y);
    }

    public double atan(Vertex v) {
        if (v == null) {
            return -1.0;
        }
        return Math.atan(this.y - v.y);
    }

    public static class DimPos {
        public Vertex pos;
        public int dim;

        public DimPos(double x, double y, double z, int d) {
            this.pos = new Vertex(x, y, z);
            this.dim = d;
        }

        public DimPos(Entity e) {
            this(e.field_70165_t, e.field_70163_u, e.field_70161_v, e.field_71093_bK);
        }

        public DimPos() {
            this(0.0, 0.0, 0.0, 0);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.pos.x = tag.func_74769_h("X");
            this.pos.y = tag.func_74769_h("Y");
            this.pos.z = tag.func_74769_h("Z");
            this.dim = tag.func_74762_e("D");
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74780_a("X", this.pos.x);
            tag.func_74780_a("Y", this.pos.y);
            tag.func_74780_a("Z", this.pos.z);
            tag.func_74768_a("D", this.dim);
        }

        public int intX() {
            return MathHelperLM.floor(this.pos.x);
        }

        public int intY() {
            return MathHelperLM.floor(this.pos.y);
        }

        public int intZ() {
            return MathHelperLM.floor(this.pos.z);
        }

        public boolean equals(Object o) {
            return o instanceof DimPos && ((DimPos)o).dim == this.dim && ((DimPos)o).pos.equalsPos(this.pos);
        }

        public static class Rot
        extends DimPos {
            public float yaw;
            public float pitch;

            public Rot(double x, double y, double z, int d, float yr, float pr) {
                super(x, y, z, d);
                this.yaw = yr;
                this.pitch = pr;
            }

            public Rot(Entity e) {
                super(e);
                this.yaw = e.field_70177_z;
                this.pitch = e.field_70125_A;
            }

            @Override
            public void readFromNBT(NBTTagCompound tag) {
                super.readFromNBT(tag);
                this.yaw = tag.func_74760_g("YR");
                this.pitch = tag.func_74760_g("PR");
            }

            @Override
            public void writeToNBT(NBTTagCompound tag) {
                super.writeToNBT(tag);
                tag.func_74776_a("YR", this.yaw);
                tag.func_74776_a("PR", this.pitch);
            }

            @Override
            public boolean equals(Object o) {
                return o instanceof Rot && super.equals(o) && ((Rot)o).yaw == this.yaw && ((Rot)o).pitch == this.pitch;
            }
        }
    }
}

