/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.util;

import java.util.Random;

public class Noise {
    public static final Noise def = new Noise();
    private static final double[] perlin_cosTable = new double[720];
    private final Random perlinRandom;
    private final double[] perlin = new double[4096];
    private int perlin_PI;
    private int perlin_TWOPI;

    public Noise(Random r) {
        this.perlinRandom = r == null ? new Random() : r;
        for (int i = 0; i < this.perlin.length; ++i) {
            this.perlin[i] = this.perlinRandom.nextDouble();
        }
        this.perlin_PI = 720;
        this.perlin_TWOPI = 720;
        this.perlin_PI >>= 1;
    }

    public Noise() {
        this(null);
    }

    public double get(double ... pos) {
        return this.get0(pos[0], pos.length >= 2 ? pos[1] : 0.0, pos.length >= 3 ? pos[2] : 0.0);
    }

    private double get0(double x, double y, double z) {
        int i = (int)Math.abs(x);
        int j = (int)Math.abs(y);
        int k = (int)Math.abs(z);
        double f1 = x - (double)i;
        double f2 = y - (double)j;
        double f3 = z - (double)k;
        double f6 = 0.0;
        double f7 = 0.5;
        for (int m = 0; m < 4; ++m) {
            int n = i + (j << 4) + (k << 8);
            double f4 = this.noise_fsc(f1);
            double f5 = this.noise_fsc(f2);
            double f8 = this.perlin[n & 0xFFF];
            f8 += f4 * (this.perlin[n + 1 & 0xFFF] - f8);
            double f9 = this.perlin[n + 16 & 0xFFF];
            f9 += f4 * (this.perlin[n + 16 + 1 & 0xFFF] - f9);
            f8 += f5 * (f9 - f8);
            f9 = this.perlin[(n += 256) & 0xFFF];
            f9 += f4 * (this.perlin[n + 1 & 0xFFF] - f9);
            double f10 = this.perlin[n + 16 & 0xFFF];
            f10 += f4 * (this.perlin[n + 16 + 1 & 0xFFF] - f10);
            f9 += f5 * (f10 - f9);
            f8 += this.noise_fsc(f3) * (f9 - f8);
            f6 += f8 * f7;
            f7 *= 0.5;
            i <<= 1;
            if ((f1 *= 2.0) >= 1.0) {
                ++i;
                f1 -= 1.0;
            }
            j <<= 1;
            if ((f2 *= 2.0) >= 1.0) {
                ++j;
                f2 -= 1.0;
            }
            k <<= 1;
            if (!((f3 *= 2.0) >= 1.0)) continue;
            ++k;
            f3 -= 1.0;
        }
        return f6;
    }

    private double noise_fsc(double f) {
        return 0.5 * (1.0 - perlin_cosTable[(int)(f * (double)this.perlin_PI) % this.perlin_TWOPI]);
    }

    static {
        for (int i = 0; i < perlin_cosTable.length; ++i) {
            Noise.perlin_cosTable[i] = Math.cos((double)i * 0.5 * (Math.PI / 180));
        }
    }
}

