/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.util;

import java.util.Iterator;
import java.util.Map;
import latmod.core.util.FastList;
import latmod.core.util.TwoObjects;

public class FastMap<K, V>
implements Iterable<V> {
    public FastList<K> keys;
    public FastList<V> values;
    private boolean nullRemoves = true;

    public FastMap(int init, int inc) {
        this.keys = new FastList(init, inc);
        this.values = new FastList(init, inc);
    }

    public FastMap<K, V> setNullRemoves(boolean b) {
        this.nullRemoves = b;
        return this;
    }

    public FastMap(int init) {
        this(init, 5);
    }

    public FastMap() {
        this(10);
    }

    public int size() {
        return this.values.size();
    }

    public V get(Object o) {
        int i = this.keys.indexOf(o);
        return i == -1 ? null : (V)this.values.get(i);
    }

    public K getKey(Object o) {
        int i = this.values.indexOf(o);
        return i == -1 ? null : (K)this.keys.get(i);
    }

    public boolean put(K k, V v) {
        int i = this.keys.indexOf(k);
        if (i != -1) {
            if (this.nullRemoves && v == null) {
                this.keys.remove(i);
                this.values.remove(i);
            } else {
                this.keys.set(i, k);
                this.values.set(i, v);
            }
            return false;
        }
        if (this.nullRemoves && v == null) {
            return false;
        }
        this.keys.add(k);
        this.values.add(v);
        return true;
    }

    public boolean remove(K k) {
        int i = this.keys.indexOf(k);
        if (i != -1) {
            this.keys.remove(i);
            this.values.remove(i);
            return true;
        }
        return false;
    }

    public boolean removeValue(V v) {
        int i = this.values.indexOf(v);
        if (i != -1) {
            this.keys.remove(i);
            this.values.remove(i);
            return true;
        }
        return false;
    }

    public boolean clear() {
        boolean b = this.hasKeys();
        this.keys.clear();
        this.values.clear();
        return b;
    }

    public FastMap<K, V> clone() {
        FastMap<K, V> map1 = new FastMap<K, V>();
        map1.keys = this.keys.clone();
        map1.values = this.values.clone();
        return map1;
    }

    public void removeAllKeys(FastList<? extends K> al) {
        for (int i = 0; i < al.size(); ++i) {
            this.remove(al.get(i));
        }
    }

    public void removeAllValues(FastList<? extends V> al) {
        for (int i = 0; i < al.size(); ++i) {
            this.removeValue(al.get(i));
        }
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public boolean hasKeys() {
        return !this.keys.isEmpty();
    }

    public void putAll(FastMap<K, V> map) {
        Iterator<K> itrK = map.keys.iterator();
        Iterator<V> itrV = map.values.iterator();
        while (itrK.hasNext() && itrV.hasNext()) {
            this.put(itrK.next(), itrV.next());
        }
    }

    public void putAll(Map<K, V> map) {
        Iterator<K> itrK = map.keySet().iterator();
        Iterator<V> itrV = map.values().iterator();
        while (itrK.hasNext() && itrV.hasNext()) {
            this.put(itrK.next(), itrV.next());
        }
    }

    @Override
    public Iterator<V> iterator() {
        return this.values.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Map { ");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.keys.get(i));
            sb.append(": ");
            sb.append(this.values.get(i));
            if (i == this.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(" }");
        return sb.toString();
    }

    public FastMap<V, K> inverse() {
        FastMap<K, V> map = new FastMap<K, V>();
        map.keys.addAll(this.values);
        map.values.addAll(this.keys);
        return map;
    }

    public FastList<TwoObjects<K, V>> toTwoObjects() {
        FastList<TwoObjects<K, V>> l = new FastList<TwoObjects<K, V>>();
        for (int i = 0; i < this.size(); ++i) {
            l.add(new TwoObjects<K, V>(this.keys.get(i), this.values.get(i)));
        }
        return l;
    }
}

