/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.tile;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import latmod.core.LMSecurity;
import latmod.core.LatCoreMC;
import latmod.core.block.BlockLM;
import latmod.core.mod.LC;
import latmod.core.net.MessageClientTileAction;
import latmod.core.net.MessageLM;
import latmod.core.tile.IClientActionTile;
import latmod.core.tile.IGuiTile;
import latmod.core.tile.ITileInterface;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;

public class TileLM
extends TileEntity
implements ITileInterface,
IClientActionTile {
    public static final String ACTION_BUTTON_PRESSED = "button";
    public static final String ACTION_OPEN_GUI = "openGUI";
    public static final String ACTION_CUSTOM_NAME = "customName";
    public static final int[] NO_SLOTS = new int[0];
    public String customName = null;
    private boolean isDirty = true;
    public boolean isLoaded = false;
    public long tick = 0L;
    public final LMSecurity security = new LMSecurity(null);
    public boolean redstonePowered = false;

    @Override
    public final TileEntity getTile() {
        return this;
    }

    public final void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readTileData(tag);
        this.readTileServerData(tag);
    }

    public final void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeTileData(tag);
        this.writeTileServerData(tag);
    }

    public final Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeTileData(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public final void onDataPacket(NetworkManager m, S35PacketUpdateTileEntity p) {
        this.readTileData(p.func_148857_g());
        this.onUpdatePacket();
    }

    public void readTileData(NBTTagCompound tag) {
        this.security.readFromNBT(tag, "Security");
        this.customName = null;
        if (tag.func_74764_b("CustomName")) {
            this.customName = tag.func_74779_i("CustomName");
        }
        this.tick = tag.func_74763_f("Tick");
        if (this.tick < 0L) {
            this.tick = 0L;
        }
    }

    public void readTileServerData(NBTTagCompound tag) {
    }

    public void writeTileData(NBTTagCompound tag) {
        this.security.writeToNBT(tag, "Security");
        if (this.customName != null) {
            tag.func_74778_a("CustomName", this.customName);
        }
        if (this.tick < 0L) {
            this.tick = 0L;
        }
        tag.func_74772_a("Tick", this.tick);
    }

    public void writeTileServerData(NBTTagCompound tag) {
    }

    public void onUpdatePacket() {
        if (this.rerenderBlock()) {
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean rerenderBlock() {
        return false;
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float x, float y, float z) {
        return false;
    }

    public void func_145843_s() {
        if (this.isLoaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.isLoaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onLoaded() {
        this.field_145854_h = this.getBlockType();
        if (this.field_145854_h != null) {
            this.isLoaded = true;
            this.getMeta();
            this.onNeighborBlockChange(this.field_145854_h);
        }
    }

    public void onUnloaded() {
        this.isLoaded = false;
    }

    public final void func_145845_h() {
        if (!this.isLoaded) {
            this.onLoaded();
        }
        this.onUpdate();
        if (this.isDirty) {
            this.isDirty = false;
            if (this.isServer()) {
                this.sendDirtyUpdate();
            }
        }
        ++this.tick;
    }

    public void onUpdate() {
    }

    public void sendDirtyUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onPlaced() {
        this.getBlockType();
        this.func_145832_p();
    }

    public void onPlacedBy(EntityPlayer ep, ItemStack is) {
        this.security.setOwner(ep);
        this.func_70296_d();
    }

    public void onBroken() {
        this.func_70296_d();
    }

    public final void printOwner(EntityPlayer ep) {
        if (this.security.owner == null) {
            LatCoreMC.printChat((ICommandSender)ep, "No owner");
        } else {
            LatCoreMC.printChat((ICommandSender)ep, LC.mod.translate("owner", this.security.owner.username));
        }
    }

    public void setMeta(int m) {
        this.field_145847_g = m;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, m, 3);
        this.isDirty = true;
    }

    public void getMeta() {
        this.field_145847_g = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public BlockLM getBlockType() {
        Block b = super.func_145838_q();
        if (b instanceof BlockLM) {
            return (BlockLM)b;
        }
        return null;
    }

    public boolean recolourBlock(ForgeDirection side, int col) {
        return false;
    }

    public boolean isMinable(EntityPlayer ep) {
        return ep == null || this.security.canInteract(ep);
    }

    public boolean isExplosionResistant() {
        return !this.security.level.isPublic();
    }

    public final void sendClientAction(String action, NBTTagCompound data) {
        MessageLM.NET.sendToServer((IMessage)new MessageClientTileAction(this, action, data));
    }

    public void clientPressButton(String button, int mouseButton) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("ID", button);
        data.func_74774_a("MB", (byte)mouseButton);
        this.sendClientAction(ACTION_BUTTON_PRESSED, data);
    }

    public void clientOpenGui(NBTTagCompound data) {
        this.sendClientAction(ACTION_OPEN_GUI, data);
    }

    public void clientCustomName(String name) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("Name", name);
        this.sendClientAction(ACTION_CUSTOM_NAME, data);
    }

    @Override
    public void onClientAction(EntityPlayer ep, String action, NBTTagCompound data) {
        if (action.equals(ACTION_BUTTON_PRESSED)) {
            String button = data.func_74779_i("ID");
            byte mouseButton = data.func_74771_c("MB");
            this.handleButton(button, mouseButton, ep);
            this.func_70296_d();
        } else if (action.equals(ACTION_OPEN_GUI)) {
            LatCoreMC.openGui(ep, (IGuiTile)((Object)this), data);
        } else if (action.equals(ACTION_CUSTOM_NAME)) {
            String name = data.func_74779_i("Name");
            this.customName = name.length() == 0 ? null : name;
            this.func_70296_d();
        }
    }

    public void handleButton(String button, int mouseButton, EntityPlayer ep) {
    }

    @Override
    public final boolean isServer() {
        return !this.field_145850_b.field_72995_K;
    }

    public final boolean isValid() {
        return !this.func_145837_r();
    }

    public void notifyNeighbors() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
    }

    public boolean equals(Object o) {
        if (o instanceof TileLM) {
            TileLM t = (TileLM)o;
            return t.field_145850_b.field_73011_w.field_76574_g == this.field_145850_b.field_73011_w.field_76574_g && t.field_145851_c == this.field_145851_c && t.field_145848_d == this.field_145848_d && t.field_145849_e == this.field_145849_e;
        }
        return false;
    }

    public boolean equalsMOP(MovingObjectPosition mop) {
        return mop != null && mop.field_72311_b == this.field_145851_c && mop.field_72312_c == this.field_145848_d && mop.field_72309_d == this.field_145849_e;
    }

    public void func_70296_d() {
        this.isDirty = true;
    }

    public void onNeighborBlockChange(Block b) {
        this.redstonePowered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public LMSecurity getSecurity() {
        return this.security;
    }

    public TileEntity getTile(int side) {
        return this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[side], this.field_145848_d + Facing.field_71587_c[side], this.field_145849_e + Facing.field_71585_d[side]);
    }
}

