/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.tile;

import latmod.core.mod.LC;

public enum InvMode {
    ENABLED("enabled"),
    ONLY_IN("onlyin"),
    ONLY_OUT("onlyout"),
    DISABLED("disabled");

    public static final InvMode[] VALUES;
    public final int ID = this.ordinal();
    public final String uname;

    private InvMode(String s) {
        this.uname = s;
    }

    public InvMode next() {
        return VALUES[(this.ID + 1) % VALUES.length];
    }

    public InvMode prev() {
        int id = this.ID - 1;
        if (id < 0) {
            id = VALUES.length - 1;
        }
        return VALUES[id];
    }

    public boolean canInsertItem() {
        return this == ENABLED || this == ONLY_IN;
    }

    public boolean canExtractItem() {
        return this == ENABLED || this == ONLY_OUT;
    }

    public String getText() {
        return LC.mod.translate("invmode." + this.uname, new Object[0]);
    }

    public String getTitle() {
        return LC.mod.translate("invmode", new Object[0]);
    }

    static {
        VALUES = InvMode.values();
    }
}

