/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import latmod.core.CustomBlockAccess;
import latmod.core.InvUtils;
import latmod.core.LatCoreMC;
import latmod.core.client.RenderBlocksCustom;
import latmod.core.tile.ITileInterface;
import latmod.core.util.MathHelperLM;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public interface IPaintable
extends ITileInterface {
    public boolean setPaint(PaintData var1);

    public static class BlockAccess
    extends CustomBlockAccess {
        public final int blockX;
        public final int blockY;
        public final int blockZ;
        public final Paint paint;

        public BlockAccess(IBlockAccess iba, int x, int y, int z, Paint p) {
            super(iba);
            this.blockX = x;
            this.blockY = y;
            this.blockZ = z;
            this.paint = p;
        }

        @Override
        public Block func_147439_a(int x, int y, int z) {
            if (this.paint != null && x == this.blockX && y == this.blockY && z == this.blockZ) {
                return this.paint.block;
            }
            return Blocks.field_150350_a;
        }

        @Override
        public int func_72805_g(int x, int y, int z) {
            if (this.paint != null && x == this.blockX && y == this.blockY && z == this.blockZ) {
                return this.paint.meta;
            }
            return 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Renderer {
        public static IIcon[] to6(IIcon p) {
            return new IIcon[]{p, p, p, p, p, p};
        }

        public static Paint[] to6(Paint p) {
            return new Paint[]{p, p, p, p, p, p};
        }

        public static void renderCube(IBlockAccess iba, RenderBlocksCustom rb, Paint[] p, IIcon[] defIcon, int x, int y, int z, AxisAlignedBB aabb) {
            for (int i = 0; i < 6; ++i) {
                rb.setFaceBounds(aabb, i);
                Renderer.renderFace(iba, rb, i, p[i], defIcon[i], x, y, z);
            }
        }

        public static void renderFace(IBlockAccess iba, RenderBlocksCustom rb, int side, Paint p, IIcon defIcon, int x, int y, int z) {
            if (rb.field_147845_a != null) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[side];
                Block b = rb.field_147845_a.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                if (b.func_149688_o() != Material.field_151579_a) {
                    double d = -1.0E-4;
                    if (side == 0) {
                        rb.field_147857_k -= d;
                        rb.field_147855_j -= d;
                    }
                    if (side == 1) {
                        rb.field_147855_j += d;
                        rb.field_147857_k += d;
                    }
                    if (side == 2) {
                        rb.field_147853_m -= d;
                        rb.field_147851_l -= d;
                    }
                    if (side == 3) {
                        rb.field_147851_l += d;
                        rb.field_147853_m += d;
                    }
                    if (side == 4) {
                        rb.field_147861_i -= d;
                        rb.field_147859_h -= d;
                    }
                    if (side == 5) {
                        rb.field_147859_h += d;
                        rb.field_147861_i += d;
                    }
                }
            }
            boolean b = rb.field_147837_f;
            rb.field_147837_f = true;
            rb.setCustomColor(null);
            rb.field_147845_a = new BlockAccess(iba, x, y, z, p);
            IIcon icon = defIcon;
            if (p != null) {
                if (p.block == null || p.block == Blocks.field_150350_a) {
                    icon = Blocks.field_150348_b.func_149733_h(1);
                } else {
                    try {
                        if (p.block instanceof ICustomPaintBlock) {
                            icon = ((ICustomPaintBlock)p.block).getCustomPaint(side, p.meta);
                            if (icon == null) {
                                icon = defIcon;
                            }
                        } else {
                            icon = p.block.func_149673_e(rb.field_147845_a, x, y, z, side);
                        }
                        if (side != 1 && p.block == Blocks.field_150349_c) {
                            rb.setCustomColor(null);
                        } else {
                            rb.setCustomColor(p.block.func_149720_d(rb.field_147845_a, x, y, z));
                        }
                    }
                    catch (Exception e) {
                        icon = Blocks.field_150348_b.func_149733_h(1);
                    }
                }
            }
            rb.func_147757_a(icon);
            rb.func_147784_q(Blocks.field_150348_b, x, y, z);
            rb.field_147837_f = b;
            rb.field_147845_a = iba;
        }
    }

    public static class Helper {
        public static ItemStack getPaintItem(ItemStack is) {
            return is.func_77942_o() && is.field_77990_d.func_74764_b("Paint") ? ItemStack.func_77949_a((NBTTagCompound)is.field_77990_d.func_74775_l("Paint")) : null;
        }

        public static ItemStack onItemRightClick(IPainterItem i, ItemStack is, World w, EntityPlayer ep) {
            if (!w.field_72995_K && ep.func_70093_af() && is.func_77942_o() && is.field_77990_d.func_74764_b("Paint")) {
                is = InvUtils.removeTags(is, "Paint");
                LatCoreMC.printChat((ICommandSender)ep, "Paint texture cleared");
            }
            return is;
        }

        public static boolean onItemUse(IPainterItem i, ItemStack is, EntityPlayer ep, World w, int x, int y, int z, int s, float x1, float y1, float z1) {
            Block b;
            if (w.field_72995_K) {
                return true;
            }
            TileEntity te = ep.field_70170_p.func_147438_o(x, y, z);
            if (te != null && te instanceof IPaintable) {
                ItemStack paint = Helper.getPaintItem(is);
                if (ep.field_71075_bZ.field_75098_d || i.canPaintBlock(is)) {
                    Block b2;
                    MovingObjectPosition mop = MathHelperLM.rayTrace(ep);
                    Paint p = null;
                    if (paint != null && paint.func_77973_b() != null && (b2 = Block.func_149634_a((Item)paint.func_77973_b())) != Blocks.field_150350_a) {
                        p = new Paint(b2, paint.func_77960_j());
                    }
                    if (mop != null && ((IPaintable)te).setPaint(new PaintData(ep, p, x, y, z, x1, y1, z1, s, mop.subHit)) && !ep.field_71075_bZ.field_75098_d) {
                        i.damagePainter(is, ep);
                    }
                }
            } else if (ep.func_70093_af() && (b = ep.field_70170_p.func_147439_a(x, y, z)) != Blocks.field_150350_a) {
                int m = ep.field_70170_p.func_72805_g(x, y, z);
                if (b.hasTileEntity(m)) {
                    return true;
                }
                if (b.func_149704_x() == 0.0 && b.func_149665_z() == 0.0 && b.func_149706_B() == 0.0 && b.func_149753_y() == 1.0 && b.func_149669_A() == 1.0 && b.func_149693_C() == 1.0) {
                    if (b instanceof INoPaint && !((INoPaint)b).hasPaint((IBlockAccess)w, x, y, z, s)) {
                        return true;
                    }
                    ItemStack paint = new ItemStack(b, 1, m);
                    try {
                        paint.func_82833_r();
                        ItemStack paint0 = Helper.getPaintItem(is);
                        if (paint0 == null || !ItemStack.func_77989_b((ItemStack)paint0, (ItemStack)paint)) {
                            if (!is.func_77942_o()) {
                                is.field_77990_d = new NBTTagCompound();
                            }
                            NBTTagCompound paintTag = new NBTTagCompound();
                            paint.func_77955_b(paintTag);
                            is.field_77990_d.func_74782_a("Paint", (NBTBase)paintTag);
                            LatCoreMC.printChat((ICommandSender)ep, "Paint texture set to " + paint.func_82833_r());
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return true;
        }
    }

    public static interface INoPaint {
        public boolean hasPaint(IBlockAccess var1, int var2, int var3, int var4, int var5);
    }

    public static interface ICustomPaintBlock {
        @SideOnly(value=Side.CLIENT)
        public IIcon getCustomPaint(int var1, int var2);
    }

    public static class PaintData {
        public final EntityPlayer player;
        public final int posX;
        public final int posY;
        public final int posZ;
        public final float hitX;
        public final float hitY;
        public final float hitZ;
        public final int side;
        public final int subHit;
        public final Paint paint;

        public PaintData(EntityPlayer ep, Paint p, int x, int y, int z, float hx, float hy, float hz, int s, int sh) {
            this.player = ep;
            this.paint = p;
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.hitX = hx;
            this.hitY = hx;
            this.hitZ = hx;
            this.side = s;
            this.subHit = sh;
        }

        public boolean canReplace(Paint p) {
            if (p == null && this.paint == null) {
                return false;
            }
            if (p == null && this.paint != null) {
                return true;
            }
            if (p != null && this.paint == null) {
                return true;
            }
            return p.block != this.paint.block || p.block == this.paint.block && p.meta != this.paint.meta;
        }
    }

    public static class Paint {
        public final Block block;
        public final int meta;

        public Paint(Block b, int m) {
            this.block = b;
            this.meta = m;
        }

        public static void readFromNBT(NBTTagCompound tag, String s, Paint[] paint) {
            Arrays.fill(paint, null);
            NBTTagList l = (NBTTagList)tag.func_74781_a(s);
            if (l != null) {
                for (int i = 0; i < l.func_74745_c(); ++i) {
                    NBTTagCompound tag1 = l.func_150305_b(i);
                    byte id = tag1.func_74771_c("ID");
                    Block b = Block.func_149729_e((int)tag1.func_74762_e("BlockID"));
                    int m = tag1.func_74762_e("Metadata");
                    if (b == null || b == Blocks.field_150350_a || b.hasTileEntity(m)) {
                        b = Blocks.field_150348_b;
                        m = 0;
                    }
                    paint[id] = new Paint(b, m);
                }
            }
        }

        public static void writeToNBT(NBTTagCompound tag, String s, Paint[] paint) {
            NBTTagList l = new NBTTagList();
            for (int i = 0; i < paint.length; ++i) {
                if (paint[i] == null) continue;
                NBTTagCompound tag1 = new NBTTagCompound();
                tag1.func_74774_a("ID", (byte)i);
                tag1.func_74768_a("BlockID", Block.func_149682_b((Block)paint[i].block));
                tag1.func_74768_a("Metadata", paint[i].meta);
                l.func_74742_a((NBTBase)tag1);
            }
            if (l.func_74745_c() > 0) {
                tag.func_74782_a(s, (NBTBase)l);
            }
        }
    }

    public static interface IPainterItem {
        public ItemStack getPaintItem(ItemStack var1);

        public boolean canPaintBlock(ItemStack var1);

        public void damagePainter(ItemStack var1, EntityPlayer var2);
    }
}

