/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.mod.cmd;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import latmod.core.InvUtils;
import latmod.core.LMPlayer;
import latmod.core.LatCoreMC;
import latmod.core.NBTHelper;
import latmod.core.Notification;
import latmod.core.cmd.CommandLM;
import latmod.core.cmd.CommandLevel;
import latmod.core.event.ReloadEvent;
import latmod.core.mod.cmd.CommandBaseLC;
import latmod.core.net.MessageLM;
import latmod.core.net.MessageReload;
import latmod.core.util.LatCore;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CmdLatCoreAdmin
extends CommandBaseLC {
    public static CommandLevel commandLevel = CommandLevel.OP;

    public CmdLatCoreAdmin() {
        super("latcoreadmin", commandLevel);
    }

    @Override
    public void printHelp(ICommandSender ics) {
    }

    @Override
    public String[] getSubcommands(ICommandSender ics) {
        return new String[]{"player", "reload"};
    }

    @Override
    public String[] getTabStrings(ICommandSender ics, String[] args, int i) {
        if (i == 0) {
            return this.getSubcommands(ics);
        }
        if (i == 2 && CmdLatCoreAdmin.isArg(args, 0, "player")) {
            return new String[]{"delete", "saveinv", "loadinv", "notify"};
        }
        return super.getTabStrings(ics, args, i);
    }

    @Override
    public CommandLM.NameType getUsername(String[] args, int i) {
        if (i == 1 && CmdLatCoreAdmin.isArg(args, 0, "player")) {
            return CommandLM.NameType.OFF;
        }
        return CommandLM.NameType.NONE;
    }

    @Override
    public String onCommand(ICommandSender ics, String[] args) {
        if (args == null || args.length == 0) {
            return "Subcommands: " + LatCore.strip(this.getTabStrings(ics, args, 0));
        }
        if (args[0].equals("player")) {
            CmdLatCoreAdmin.checkArgs(args, 2);
            String mustBeOnline = "The player must be online!";
            String mustBeOffline = "The player must be offline!";
            if (args[1].equals("@a")) {
                String[] s = LMPlayer.getAllNames(CommandLM.NameType.ON);
                for (int i = 0; i < s.length; ++i) {
                    String[] args1 = (String[])args.clone();
                    args1[1] = s[i];
                    this.onCommand(ics, args1);
                }
                return null;
            }
            LMPlayer p = CmdLatCoreAdmin.getLMPlayer(args[1]);
            if (args[2].equals("delete")) {
                if (p.isOnline()) {
                    return mustBeOffline;
                }
                LMPlayer.map.remove(p.playerID);
                return FINE + "Player removed!";
            }
            if (args[2].equals("saveinv")) {
                if (!p.isOnline()) {
                    return mustBeOnline;
                }
                try {
                    IInventory inv;
                    EntityPlayerMP ep = p.getPlayerMP();
                    NBTTagCompound tag = new NBTTagCompound();
                    CmdLatCoreAdmin.writeItemsToNBT((IInventory)ep.field_71071_by, tag, "Inventory");
                    if (LatCoreMC.isModInstalled("Baubles") && (inv = BaublesApi.getBaubles((EntityPlayer)ep)) != null) {
                        CmdLatCoreAdmin.writeItemsToNBT(inv, tag, "Baubles");
                    }
                    NBTHelper.writeMap(new FileOutputStream(LatCore.newFile(new File(LatCoreMC.latmodFolder, "playerinvs/" + ep.func_70005_c_() + ".dat"))), tag);
                }
                catch (Exception e) {
                    if (LatCoreMC.isDevEnv) {
                        e.printStackTrace();
                    }
                    return "Failed to save inventory!";
                }
                return FINE + "Inventory saved!";
            }
            if (args[2].equals("loadinv")) {
                if (!p.isOnline()) {
                    return mustBeOnline;
                }
                try {
                    IInventory inv;
                    EntityPlayerMP ep = p.getPlayerMP();
                    NBTTagCompound tag = NBTHelper.readMap(new FileInputStream(new File(LatCoreMC.latmodFolder, "playerinvs/" + ep.func_70005_c_() + ".dat")));
                    CmdLatCoreAdmin.readItemsFromNBT((IInventory)ep.field_71071_by, tag, "Inventory");
                    if (LatCoreMC.isModInstalled("Baubles") && (inv = BaublesApi.getBaubles((EntityPlayer)ep)) != null) {
                        CmdLatCoreAdmin.readItemsFromNBT(inv, tag, "Baubles");
                    }
                }
                catch (Exception e) {
                    if (LatCoreMC.isDevEnv) {
                        e.printStackTrace();
                    }
                    return "Failed to load inventory!";
                }
                return FINE + "Inventory loaded!";
            }
            if (args[2].equals("notify")) {
                if (!p.isOnline()) {
                    return "The player must be online!";
                }
                CmdLatCoreAdmin.checkArgsStrong(args, 5);
                ItemStack is = InvUtils.parseItem(args[3]);
                if (is == null || is.func_77973_b() == null) {
                    return "Item '" + args[3] + "' not found!";
                }
                LatCoreMC.notifyPlayer(p.getPlayerMP(), new Notification(args[4].replace("\\_", "<$US>").replace('_', ' ').replace("<$US>", "_"), "", is));
                return null;
            }
        } else if (args[0].equals("reload")) {
            new ReloadEvent(Side.SERVER, ics).post();
            MessageLM.NET.sendToAll((IMessage)new MessageReload());
            return FINE + "LatvianModders's mods reloaded (Server)";
        }
        return this.onCommand(ics, null);
    }

    private static void writeItemsToNBT(IInventory inv, NBTTagCompound tag, String s) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (is == null) continue;
            NBTTagCompound tag1 = new NBTTagCompound();
            tag1.func_74777_a("S", (short)i);
            tag1.func_74778_a("ID", InvUtils.getRegName(is.func_77973_b()));
            tag1.func_74774_a("C", (byte)is.field_77994_a);
            tag1.func_74777_a("D", (short)is.func_77960_j());
            if (is.field_77990_d != null) {
                tag1.func_74782_a("T", (NBTBase)is.field_77990_d);
            }
            list.func_74742_a((NBTBase)tag1);
        }
        if (list.func_74745_c() > 0) {
            tag.func_74782_a(s, (NBTBase)list);
        }
    }

    private static void readItemsFromNBT(IInventory inv, NBTTagCompound tag, String s) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            inv.func_70299_a(i, null);
        }
        if (tag.func_74764_b(s)) {
            NBTTagList list = tag.func_150295_c(s, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag1 = list.func_150305_b(i);
                Item item = InvUtils.getItemFromRegName(tag1.func_74779_i("ID"));
                if (item != null) {
                    short slot = tag1.func_74765_d("S");
                    byte size = tag1.func_74771_c("C");
                    int dmg = Math.max(0, tag1.func_74765_d("D"));
                    ItemStack is = new ItemStack(item, (int)size, dmg);
                    if (tag1.func_150297_b("T", 10)) {
                        is.func_77982_d(tag1.func_74775_l("T"));
                    }
                    inv.func_70299_a((int)slot, is);
                }
                if (i >= inv.func_70302_i_()) break;
            }
        }
        inv.func_70296_d();
    }
}

