/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.mod;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import latmod.core.IServerConfig;
import latmod.core.LMConfig;
import latmod.core.mod.LC;
import latmod.core.util.FastList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Property;

public class LCConfig
extends LMConfig
implements IServerConfig {
    public static LCConfig instance;

    public LCConfig(FMLPreInitializationEvent e) {
        super(e, "/LatMod/LatCoreMC.cfg");
        instance = this;
        this.load();
    }

    @Override
    public void load() {
        General.load(this.get("general"));
        Client.load(this.get("client"));
        Recipes.load(this.get("recipes"));
        this.save();
    }

    @Override
    public void readConfig(NBTTagCompound tag) {
        boolean[] b = LCConfig.readBools(tag, "C");
        General.friendsGuiArmor = b[0];
    }

    @Override
    public void writeConfig(NBTTagCompound tag) {
        LCConfig.writeBools(tag, "C", General.friendsGuiArmor);
    }

    public static class Recipes {
        public static boolean smeltFleshToLeather;

        public static void load(LMConfig.Category c) {
            smeltFleshToLeather = c.getBool("smeltFleshToLeather", true);
        }

        public static void loadRecipes() {
            if (smeltFleshToLeather) {
                LC.mod.recipes.addSmelting(new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151078_bh));
            }
        }
    }

    public static class Client {
        public static boolean enablePlayerDecorators;
        public static boolean rotateBlocks;
        public static boolean renderHighlights;
        public static boolean addAllColorItems;
        public static boolean addOreNames;
        public static boolean addRegistryNames;
        public static boolean displayDebugInfo;

        public static void load(LMConfig.Category c) {
            FastList<String> p = new FastList<String>();
            enablePlayerDecorators = c.getBool("EnablePlayerDecorators", true);
            p.add("EnablePlayerDecorators");
            rotateBlocks = c.getBool("RotateBlocks", true);
            p.add("RotateBlocks");
            renderHighlights = c.getBool("RenderHighlights", true);
            p.add("RenderHighlights");
            addAllColorItems = c.getBool("AddAllColorItems", true);
            p.add("AddAllColorItems");
            addOreNames = c.getBool("AddOreNames", false);
            p.add("AddOreNames");
            addRegistryNames = c.getBool("AddRegistryNames", false);
            p.add("AddRegistryNames");
            displayDebugInfo = c.getBool("DisplayDebugInfo", false);
            p.add("DisplayDebugInfo");
            FastList l = new FastList();
            l.addAll(c.getCategory().values());
            for (int i = 0; i < l.size(); ++i) {
                String p1 = ((Property)l.get(i)).getName();
                if (p.contains(p1)) continue;
                c.getCategory().remove((Object)p1);
            }
        }
    }

    public static class General {
        public static boolean disableLatCoreCommand;
        public static boolean disableLMFriendsCommand;
        public static boolean friendsGuiArmor;
        public static boolean allowCreativeInteractSecure;

        public static void load(LMConfig.Category c) {
            c.remove("checkUpdates");
            disableLatCoreCommand = c.getBool("disableLatCoreCommand", false);
            disableLMFriendsCommand = c.getBool("disableLMFriendsCommand", false);
            friendsGuiArmor = c.getBool("friendsGuiArmor", true);
            allowCreativeInteractSecure = c.getBool("allowCreativeInteractSecure", true);
        }
    }
}

