/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.mod;

import com.cricketcraft.chisel.api.carving.CarvingUtils;
import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingRegistry;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import java.util.List;
import latmod.core.LatCoreMC;
import latmod.core.util.FastList;
import net.minecraft.block.Block;

public class ChiselHelper {
    private static Boolean isInstalled = null;

    public static final boolean isInstalled() {
        if (isInstalled == null) {
            isInstalled = LatCoreMC.isModInstalled("chisel");
        }
        return isInstalled;
    }

    public static void register(ICarvingGroup g) {
        if (ChiselHelper.isInstalled()) {
            try {
                ICarvingRegistry r = CarvingUtils.getChiselRegistry();
                if (r == null) {
                    isInstalled = false;
                } else {
                    r.addGroup(g);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class Variation
    implements ICarvingVariation {
        public final Block block;
        public final int blockMeta;
        public final int itemMeta;
        public final int order;

        public Variation(Block b, int bm, int im, int o) {
            this.block = b;
            this.blockMeta = bm;
            this.itemMeta = im;
            this.order = o;
        }

        @Override
        public Block getBlock() {
            return this.block;
        }

        @Override
        public int getBlockMeta() {
            return this.blockMeta;
        }

        @Override
        public int getItemMeta() {
            return this.itemMeta;
        }

        @Override
        public int getOrder() {
            return this.order;
        }
    }

    public static class Group
    implements ICarvingGroup {
        public final Block block;
        public String name = "Unnamed";
        public String sound = null;
        public String oreName = null;
        public final FastList<ICarvingVariation> variations = new FastList();

        public Group(Block b) {
            this.block = b;
        }

        public void addVariation(Block b, int itemMeta, int blockMeta) {
            this.variations.add(new Variation(b, blockMeta, itemMeta, this.variations.size()));
        }

        public void addVariation(Block b, int meta) {
            this.addVariation(b, meta, meta);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSound() {
            return this.sound;
        }

        @Override
        public void setSound(String s) {
            this.sound = s;
        }

        @Override
        public String getOreName() {
            return this.oreName;
        }

        @Override
        public void setOreName(String s) {
        }

        @Override
        public List<ICarvingVariation> getVariations() {
            return this.variations;
        }

        @Override
        public void addVariation(ICarvingVariation v) {
        }

        @Override
        public boolean removeVariation(ICarvingVariation v) {
            return false;
        }
    }
}

