/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.gui.GuiLM;
import latmod.core.gui.WidgetLM;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class TextBoxLM
extends WidgetLM {
    public boolean isSelected = false;
    public String text = "";
    public int charLimit = -1;

    public TextBoxLM(GuiLM g, int x, int y, int w, int h) {
        super(g, x, y, w, h);
    }

    @Override
    public boolean mousePressed(int mx, int my, int b) {
        if (this.mouseOver(mx, my)) {
            this.isSelected = true;
            Keyboard.enableRepeatEvents((boolean)true);
            if (b == 1 && this.text.length() > 0) {
                this.text = "";
                this.textChanged();
            }
            return true;
        }
        return false;
    }

    public boolean canAddChar(char c) {
        return this.charLimit == -1 || this.text.length() + 1 <= this.charLimit;
    }

    @Override
    public void voidMousePressed(int mx, int my, int b) {
        Keyboard.enableRepeatEvents((boolean)false);
        this.isSelected = false;
    }

    @Override
    public boolean keyPressed(int key, char keyChar) {
        if (this.isSelected) {
            if (key == 14) {
                if (this.text.length() > 0) {
                    this.text = GuiScreen.func_146271_m() ? "" : this.text.substring(0, this.text.length() - 1);
                    this.textChanged();
                }
            } else if (key == 1) {
                this.isSelected = false;
            } else if (key == 15) {
                this.tabPressed();
                this.isSelected = false;
            } else if (key == 28) {
                this.returnPressed();
                this.isSelected = false;
            } else if (ChatAllowedCharacters.func_71566_a((char)keyChar) && this.canAddChar(keyChar)) {
                this.text = this.text + keyChar;
                this.textChanged();
            }
            return true;
        }
        return false;
    }

    public void textChanged() {
    }

    public void tabPressed() {
    }

    public void returnPressed() {
    }

    public void clear() {
        this.text = "";
    }

    public String getText() {
        if (this.text == null) {
            this.text = "";
        }
        return this.text;
    }

    public void render(int x, int y, int col) {
        String s = this.getText();
        if (this.isSelected && Minecraft.func_71386_F() % 1000L > 500L) {
            s = s + '_';
        }
        if (s.length() > 0) {
            this.gui.getFontRenderer().func_78276_b(s, this.gui.getPosX() + x, this.gui.getPosY() + y, col);
        }
    }

    public void renderCentred(int x, int y, int col) {
        String s = this.getText();
        String os = s + "";
        if (this.isSelected && Minecraft.func_71386_F() % 1000L > 500L) {
            s = s + '_';
        }
        if (s.length() > 0) {
            this.gui.getFontRenderer().func_78276_b(s, this.gui.getPosX() + x - this.gui.getFontRenderer().func_78256_a(os) / 2, this.gui.getPosY() + y, col);
        }
    }
}

