/*
 * Decompiled with CFR 0.152.
 */
package latmod.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import latmod.core.util.FastList;
import latmod.core.util.FastMap;
import latmod.core.util.LatCore;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class NBTHelper {
    public static final int END = 0;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int INT = 3;
    public static final int LONG = 4;
    public static final int FLOAT = 5;
    public static final int DOUBLE = 6;
    public static final int BYTE_ARRAY = 7;
    public static final int STRING = 8;
    public static final int LIST = 9;
    public static final int MAP = 10;
    public static final int INT_ARRAY = 11;

    public static FastList<String> getMapKeys(NBTTagCompound tag) {
        FastList<String> list = new FastList<String>();
        list.addAll(tag.func_150296_c());
        return list;
    }

    public static FastMap<String, NBTBase> toFastMap(NBTTagCompound tag) {
        FastMap<String, NBTBase> map = new FastMap<String, NBTBase>();
        FastList<String> keys = NBTHelper.getMapKeys(tag);
        for (int i = 0; i < keys.size(); ++i) {
            String s = keys.get(i);
            map.put(s, tag.func_74781_a(s));
        }
        return map;
    }

    public static <E extends NBTBase> FastMap<String, E> toFastMapWithType(NBTTagCompound tag) {
        FastMap<String, NBTBase> map = new FastMap<String, NBTBase>();
        FastList<String> keys = NBTHelper.getMapKeys(tag);
        for (int i = 0; i < keys.size(); ++i) {
            String s = keys.get(i);
            map.put(s, tag.func_74781_a(s));
        }
        return map;
    }

    public static void writeMap(OutputStream os, NBTTagCompound tag) throws Exception {
        byte[] b = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
        os.write(b);
        os.flush();
        os.close();
    }

    public static void writeMap(File f, NBTTagCompound tag) {
        try {
            NBTHelper.writeMap(new FileOutputStream(LatCore.newFile(f)), tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static NBTTagCompound readMap(InputStream is) throws Exception {
        byte[] b = new byte[is.available()];
        is.read(b);
        is.close();
        return CompressedStreamTools.func_152457_a((byte[])b, (NBTSizeTracker)new NBTSizeTracker(Long.MAX_VALUE));
    }

    public static NBTTagCompound readMap(File f) {
        if (f == null || !f.exists()) {
            return null;
        }
        try {
            return NBTHelper.readMap(new FileInputStream(f));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean areTagsEqual(NBTTagCompound tag1, NBTTagCompound tag2) {
        if (tag1 == null && tag2 == null) {
            return true;
        }
        if (tag1 != null && tag2 == null) {
            return false;
        }
        if (tag1 == null && tag2 != null) {
            return false;
        }
        return tag1.equals((Object)tag2);
    }
}

