/*
 * Decompiled with CFR 0.152.
 */
package latmod.core;

import java.util.UUID;
import latmod.core.LMPlayer;
import latmod.core.mod.LC;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class LMSecurity {
    public LMPlayer owner;
    public Level level;

    public LMSecurity(Object o) {
        this.setOwner(o);
        this.level = Level.PUBLIC;
    }

    public void setOwner(Object o) {
        this.owner = LMPlayer.getPlayer(o);
    }

    public void readFromNBT(NBTTagCompound tag, String s) {
        this.owner = null;
        this.level = Level.PUBLIC;
        if (!tag.func_74764_b(s)) {
            return;
        }
        NBTTagCompound tag1 = tag.func_74775_l(s);
        if (tag1.func_150299_b("Owner") == 8) {
            String o = tag1.func_74779_i("Owner");
            if (o != null && !o.isEmpty()) {
                this.owner = LMPlayer.getPlayer(o);
            }
        } else {
            int o = tag1.func_74762_e("Owner");
            if (o > 0) {
                this.owner = LMPlayer.getPlayer(o);
            }
        }
        this.level = Level.VALUES[tag1.func_74771_c("Level")];
    }

    public void writeToNBT(NBTTagCompound tag, String s) {
        if (this.owner != null) {
            NBTTagCompound tag1 = new NBTTagCompound();
            tag1.func_74768_a("Owner", this.owner.playerID);
            tag1.func_74774_a("Level", (byte)this.level.ID);
            tag.func_74782_a(s, (NBTBase)tag1);
        }
    }

    public boolean isOwner(Object o) {
        return this.owner != null && this.owner.equals(o);
    }

    public boolean canInteract(UUID id) {
        if (this.level == Level.PUBLIC || this.owner == null) {
            return true;
        }
        if (id == null) {
            return false;
        }
        if (this.isOwner(id)) {
            return true;
        }
        if (this.level == Level.PRIVATE) {
            return false;
        }
        return this.level == Level.FRIENDS && this.owner.isFriend(LMPlayer.getPlayer(id));
    }

    public boolean canInteract(EntityPlayer ep) {
        return this.canInteract(ep == null ? null : ep.func_110124_au());
    }

    public static enum Level {
        PUBLIC("public"),
        PRIVATE("private"),
        FRIENDS("friends");

        public static final Level[] VALUES;
        public static final Level[] VALUES_2;
        public final int ID = this.ordinal();
        private String uname;

        private Level(String s) {
            this.uname = s;
        }

        public boolean isPublic() {
            return this == PUBLIC;
        }

        public boolean isRestricted() {
            return this == FRIENDS;
        }

        public Level next(Level[] l) {
            return l[(this.ID + 1) % l.length];
        }

        public Level prev(Level[] l) {
            int id = this.ID - 1;
            if (id < 0) {
                id = l.length - 1;
            }
            return l[id];
        }

        public String getText() {
            return LC.mod.translate("security." + this.uname, new Object[0]);
        }

        public String getTitle() {
            return LC.mod.translate("security", new Object[0]);
        }

        static {
            VALUES = Level.values();
            VALUES_2 = new Level[]{PUBLIC, PRIVATE};
        }
    }
}

