/*
 * Decompiled with CFR 0.152.
 */
package latmod.core;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import latmod.core.InvUtils;
import latmod.core.LatCoreMC;
import latmod.core.cmd.CommandLM;
import latmod.core.event.LMPlayerEvent;
import latmod.core.mod.LC;
import latmod.core.net.MessageLM;
import latmod.core.net.MessageLMPlayerUpdate;
import latmod.core.util.FastList;
import latmod.core.util.FastMap;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class LMPlayer
implements Comparable<LMPlayer> {
    public static final String ACTION_GROUPS_CHANGED = "latcore.groups";
    public final int playerID;
    public final UUID uuid;
    public final String username;
    public final String uuidString;
    public final FastList<LMPlayer> friends;
    public final ItemStack[] lastArmor;
    public final NBTTagCompound tempData;
    public NBTTagCompound commonData;
    public NBTTagCompound serverData;
    private boolean isOnline;
    public static final FastMap<Integer, LMPlayer> map = new FastMap();

    public LMPlayer(int i, UUID id, String s) {
        this.playerID = i;
        this.uuid = id;
        this.username = s;
        this.uuidString = this.uuid.toString();
        this.friends = new FastList();
        this.lastArmor = new ItemStack[5];
        this.commonData = new NBTTagCompound();
        this.serverData = new NBTTagCompound();
        this.tempData = new NBTTagCompound();
    }

    public EntityPlayerMP getPlayerMP() {
        return LatCoreMC.getAllOnlinePlayers().get(this.uuid);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityPlayerSP getPlayerSP() {
        EntityPlayer ep;
        World w = LC.proxy.getClientWorld();
        if (w != null && (ep = w.func_152378_a(this.uuid)) != null && ep instanceof EntityPlayerSP) {
            return (EntityPlayerSP)ep;
        }
        return null;
    }

    public void sendUpdate(String action, boolean updateClient) {
        if (LatCoreMC.isServer()) {
            new LMPlayerEvent.DataChanged(this, action).post();
            if (updateClient) {
                MessageLM.NET.sendToAll((IMessage)new MessageLMPlayerUpdate(this, action));
            }
        }
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public void setOnline(boolean b) {
        this.isOnline = b;
    }

    public boolean isFriendRaw(LMPlayer p) {
        return p != null && (this.playerID == p.playerID || this.friends.contains(p.playerID));
    }

    public boolean isFriend(LMPlayer p) {
        return this.isFriendRaw(p) && p.isFriendRaw(this);
    }

    public void readFromNBT(NBTTagCompound tag, boolean server) {
        this.isOnline = tag.func_74767_n("On");
        this.friends.clear();
        int[] fl = tag.func_74759_k("Friends");
        if (fl != null && fl.length > 0) {
            for (int j = 0; j < fl.length; ++j) {
                LMPlayer p = LMPlayer.getPlayer(fl[j]);
                if (p == null) continue;
                this.friends.add(p);
            }
        }
        this.commonData = tag.func_74775_l("CustomData");
        if (server) {
            this.serverData = tag.func_74775_l("ServerData");
        }
        InvUtils.readItemsFromNBT(this.lastArmor, tag, "LastItems");
    }

    public void writeToNBT(NBTTagCompound tag, boolean server) {
        int[] m;
        if (this.isOnline) {
            tag.func_74757_a("On", this.isOnline);
        }
        if (!this.friends.isEmpty() && (m = new int[this.friends.size()]).length > 0) {
            for (int j = 0; j < m.length; ++j) {
                m[j] = this.friends.get((int)j).playerID;
            }
            tag.func_74783_a("Friends", m);
        }
        tag.func_74782_a("CustomData", (NBTBase)this.commonData);
        if (server) {
            tag.func_74782_a("ServerData", (NBTBase)this.serverData);
        }
        InvUtils.writeItemsToNBT(this.lastArmor, tag, "LastItems");
    }

    @Override
    public int compareTo(LMPlayer o) {
        return Integer.compare(this.playerID, o.playerID);
    }

    public String toString() {
        return this.username;
    }

    public int hashCode() {
        return this.playerID;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Integer) {
            return (Integer)o == this.playerID;
        }
        if (o instanceof UUID) {
            return ((UUID)o).equals(this.uuid);
        }
        if (o instanceof EntityPlayer) {
            return ((EntityPlayer)o).func_110124_au().equals(this.uuid);
        }
        if (o instanceof LMPlayer) {
            return this.playerID == o.hashCode();
        }
        if (o instanceof String) {
            return this.username.equalsIgnoreCase(o.toString()) || this.uuidString.equalsIgnoreCase(o.toString());
        }
        return false;
    }

    public boolean isOP() {
        return LatCoreMC.getServer().func_152358_ax().func_152652_a(this.uuid) != null;
    }

    public CommandLM.NameType getNameType() {
        return this.isOnline() ? CommandLM.NameType.ON : CommandLM.NameType.OFF;
    }

    public static LMPlayer getPlayer(Object o) {
        if (o == null || o instanceof FakePlayer) {
            return null;
        }
        if (o instanceof LMPlayer) {
            return map.get(o.hashCode());
        }
        if (o instanceof Integer) {
            return o.hashCode() > 0 ? map.get(o) : null;
        }
        return (LMPlayer)LMPlayer.map.values.getObj(o);
    }

    public static String[] getAllNames(CommandLM.NameType type) {
        int i;
        if (type == CommandLM.NameType.NONE) {
            return new String[0];
        }
        FastList<String> allOn = new FastList<String>();
        FastList<String> allOff = new FastList<String>();
        for (i = 0; i < LMPlayer.map.values.size(); ++i) {
            LMPlayer p = (LMPlayer)LMPlayer.map.values.get(i);
            String s = LatCoreMC.removeFormatting(p.username);
            if (p.isOnline()) {
                allOn.add(s);
                continue;
            }
            if (type.isOnline()) continue;
            allOff.add(s);
        }
        allOn.sort(null);
        if (!type.isOnline()) {
            allOff.sort(null);
            for (i = 0; i < allOff.size(); ++i) {
                String s = (String)allOff.get(i);
                if (allOn.contains(s)) continue;
                allOn.add(s);
            }
        }
        return allOn.toArray((E[])new String[0]);
    }
}

