/*
 * Decompiled with CFR 0.152.
 */
package latmod.core;

import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.regex.Pattern;
import latmod.core.LMMod;
import latmod.core.mod.LC;
import latmod.core.util.Bits;
import latmod.core.util.FastList;
import latmod.core.util.LatCore;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class LMConfig {
    public final File loadedFrom;
    public final Configuration config;
    public LMMod mod = null;

    public LMConfig(File f) {
        this.loadedFrom = f;
        this.config = new Configuration(this.loadedFrom);
        this.load();
        this.save();
    }

    public LMConfig(FMLPreInitializationEvent e, String s) {
        this(new File(e.getModConfigurationDirectory(), s));
    }

    public void setMod(LMMod m) {
        this.mod = m;
    }

    public void save() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Category get(String s) {
        return new Category(this, s);
    }

    public ConfigCategory getCategory(String s) {
        return this.config.getCategory(s);
    }

    @SideOnly(value=Side.CLIENT)
    public String getAbridgedPath() {
        return GuiConfig.getAbridgedConfigPath((String)LC.mod.config.config.toString());
    }

    public String getLang(String s) {
        return (this.mod == null ? "" : this.mod.assets.replace(':', '.')) + "config." + s;
    }

    public abstract void load();

    public void reload() {
        this.config.load();
        this.load();
    }

    public String getConfigName() {
        return this.mod == null ? null : this.mod.modID;
    }

    public static boolean[] readBools(NBTTagCompound tag, String s) {
        return Bits.fromBits(tag.func_74771_c(s) & 0xFF, 8);
    }

    public static void writeBools(NBTTagCompound tag, String s, boolean ... b) {
        if (b.length <= 0 || b.length > 8) {
            throw new IllegalArgumentException("0 < " + b.length + " <= 8");
        }
        tag.func_74774_a(s, (byte)Bits.toBits(b));
    }

    public static final class Category {
        public final LMConfig config;
        public final String cat;

        private Category(LMConfig c, String s) {
            this.config = c;
            this.cat = s;
        }

        public String getString(String s, String def) {
            return this.getString(s, def, (Pattern)null);
        }

        public String getString(String s, String def, String[] valid) {
            return this.config.config.getString(s, this.cat, def, "", valid, this.config.getLang(s));
        }

        public String getString(String s, String def, Pattern p) {
            return this.config.config.getString(s, this.cat, def, "", this.config.getLang(s), p);
        }

        public boolean getBool(String s, boolean def) {
            return this.config.config.getBoolean(s, this.cat, def, "", this.config.getLang(s));
        }

        public int getInt(String s, int def, int min, int max) {
            return this.config.config.getInt(s, this.cat, def, min, max, "", this.config.getLang(s));
        }

        public int getInt(String s, int def) {
            return this.getInt(s, def, -1, Integer.MAX_VALUE);
        }

        public float getFloat(String s, float def, float min, float max) {
            return this.config.config.getFloat(s, this.cat, def, min, max, "", this.config.getLang(s));
        }

        public float getFloat(String s, float def) {
            return this.getFloat(s, def, -1.0f, Float.MAX_VALUE);
        }

        public FastList<String> getStringArray(String s, String[] def, String[] valid) {
            return FastList.asList(this.config.config.getStringList(s, this.cat, def, "", valid, this.config.getLang(s)));
        }

        public FastList<String> getStringArray(String s, String[] def) {
            return this.getStringArray(s, def, new String[0]);
        }

        public ConfigCategory getCategory() {
            return this.config.config.getCategory(this.cat);
        }

        public void setComment(String property, String ... comment) {
            if (comment == null || comment.length == 0) {
                return;
            }
            ConfigCategory cat1 = this.getCategory();
            Property prop = cat1.get(property);
            if (prop != null) {
                String s = "";
                for (int i = 0; i < comment.length; ++i) {
                    s = s + comment[i];
                    if (i >= comment.length - 1) continue;
                    s = s + '\n';
                }
                prop.comment = s;
            }
        }

        public void setCategoryComment(String ... comment) {
            this.config.config.setCategoryComment(this.cat, LatCore.unsplit(comment, "\n"));
        }

        public void setLang(String property, String langKey) {
            ConfigCategory cat1 = this.getCategory();
            Property prop = cat1.get(property);
            if (prop != null) {
                prop.setLanguageKey(langKey);
            }
        }

        public void remove(String s) {
            ConfigCategory cat1 = this.getCategory();
            if (cat1.containsKey(s)) {
                cat1.remove((Object)s);
            }
        }
    }
}

