/*
 * Decompiled with CFR 0.152.
 */
package particlephysics.tileentity.emitter;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import particlephysics.entity.particle.TemplateParticle;
import particlephysics.network.MessageHandler;
import particlephysics.network.message.MessageEmitterUpdate;
import particlephysics.tileentity.emitter.EmitterContainer;
import particlephysics.tileentity.emitter.EmitterTileEntity;
import particlephysics.utility.GUIRectangle;

public class EmitterGUI
extends GuiContainer {
    protected static final ResourceLocation texture = new ResourceLocation("particlephysics", "textures/gui/emitter.png");
    private final EmitterTileEntity tile;
    public static final int sliderLeftOffset = 38;
    protected int intervalPercent = 0;
    protected int progressBar = 0;
    protected int progressVertical = 0;
    protected int progressHorizontal = 0;
    protected int burstOffset = 0;
    protected int guiParticle = 0;
    protected int fuelLoadVertical = 0;
    protected int fuelLoadhorizontal = 0;
    protected long oldTick = 0L;
    protected long tickCounter = 0L;
    protected int tempHeightSetting = 25;
    protected boolean isDragging;
    public static final GUIRectangle bar = new GUIRectangle(38, 15, 87, 6);
    public static final GUIRectangle slider = new GUIRectangle(38, 12, 8, 11);

    public EmitterGUI(InventoryPlayer invPlayer, EmitterTileEntity tile) {
        super((Container)new EmitterContainer(invPlayer, tile));
        this.tile = tile;
        this.field_146999_f = 176;
        this.field_147000_g = 218;
        this.syncGUIElements();
    }

    protected void func_146976_a(float f, int x, int y) {
        TemplateParticle particle;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.intervalReset > 0 && this.tile.fuelStored != 0) {
            this.intervalPercent = (int)((float)this.tile.intervalReset / (float)((this.tile.interval + 1) * 20) * 200.0f);
            this.progressBar = (int)((float)this.intervalPercent * 0.7f);
            if (this.intervalPercent <= 100) {
                this.burstOffset = 0;
                if (this.progressBar <= 7) {
                    this.progressVertical = this.progressBar;
                    this.progressHorizontal = 0;
                } else {
                    this.progressVertical = 7;
                    this.progressHorizontal = this.progressBar - 6;
                }
            } else {
                this.burstOffset = this.intervalPercent >= 100 && this.intervalPercent <= 200 ? (int)((float)this.tile.intervalReset / (float)((this.tile.interval + 1) * 20) * 20.0f) - 11 : 0;
            }
        }
        if (this.intervalPercent >= 0 && this.intervalPercent <= 200 && this.tile.fuelStored != 0) {
            this.func_73729_b(this.field_147003_i + 42, this.field_147009_r + 38 - this.progressVertical, 211, 20 - this.progressVertical, 5, this.progressVertical);
            this.func_73729_b(this.field_147003_i + 42, this.field_147009_r + 27, 191, 0, this.progressHorizontal + 1, 10);
            if (this.intervalPercent >= 100) {
                if (this.intervalPercent <= 113) {
                    this.guiParticle = (int)((float)(this.intervalPercent - 100));
                    if (this.tile.interval <= 1) {
                        this.guiParticle += 3;
                    }
                }
                this.func_73729_b(this.field_147003_i + 105 + this.guiParticle, this.field_147009_r + 31, 254, 4, 2, 2);
                this.func_73729_b(this.field_147003_i + 118 - this.burstOffset, this.field_147009_r + 31 - this.burstOffset, 200 - this.burstOffset, 22 - this.burstOffset, 2 + this.burstOffset * 2, 2 + this.burstOffset * 2);
            }
        }
        if (this.tile.fuelStored > 0) {
            int offset = this.tile.fuelStored / 2;
            this.func_73729_b(this.field_147003_i + 37, this.field_147009_r + 89 - offset, 176, 50 - offset, 15, 0 + offset);
        }
        if (this.tile.fuelStored <= 1) {
            if (this.oldTick != this.tile.func_145831_w().func_72820_D()) {
                this.oldTick = this.tile.func_145831_w().func_72820_D();
                ++this.tickCounter;
                if (this.tickCounter >= (long)(10 + 20 * this.tile.interval * 2)) {
                    if (this.fuelLoadVertical <= 13) {
                        ++this.fuelLoadVertical;
                    } else if (this.fuelLoadhorizontal <= 18) {
                        ++this.fuelLoadhorizontal;
                    }
                }
            }
            if (this.tile.inventory[0] != null) {
                this.func_73729_b(this.field_147003_i + 10, this.field_147009_r + 70 - this.fuelLoadVertical, 191, 47 - this.fuelLoadVertical, 13, this.fuelLoadVertical);
                this.func_73729_b(this.field_147003_i + 17, this.field_147009_r + 53, 225, 13, this.fuelLoadhorizontal, 8);
            }
        } else {
            this.fuelLoadVertical = 0;
            this.fuelLoadhorizontal = 0;
            this.tickCounter = 0L;
        }
        if (!this.isDragging) {
            this.tempHeightSetting = this.tile.interval;
        }
        bar.draw(this, 0, 218);
        this.updateSliderPosition();
        slider.draw(this, 0, 224);
        this.field_146289_q.func_78276_b(this.tempHeightSetting + 1 + " Seconds", this.field_147003_i + 48, this.field_147009_r + 4, 0x404040);
        this.field_146289_q.func_78276_b("Queue", this.field_147003_i + 85, this.field_147009_r + 101, 0x404040);
        if (this.tile.func_70301_a(0) != null && (particle = this.tile.getParticleFromFuel(this.tile.func_70301_a(0))) != null) {
            this.field_146289_q.func_78276_b(particle.getName(), this.field_147003_i + 115, this.field_147009_r + 46, 0x404040);
            this.field_146289_q.func_78276_b("Type:", this.field_147003_i + 89, this.field_147009_r + 46, 0x404040);
        }
    }

    public int getLeft() {
        return this.field_147003_i;
    }

    public int getTop() {
        return this.field_147009_r;
    }

    public void drawHoverString(List l, int w, int h) {
        this.drawHoveringText(l, w, h, this.field_146289_q);
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        MessageEmitterUpdate message = new MessageEmitterUpdate(0, button.field_146127_k);
        MessageHandler.INSATNCE.sendToServer((IMessage)message);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        GuiButton clearButton = new GuiButton(0, this.field_147003_i + 54, this.field_147009_r + 70, 31, 20, "Dump");
        this.field_146292_n.add(clearButton);
    }

    public void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (slider.inRect(this, x, y)) {
            this.isDragging = true;
            this.tempHeightSetting = this.tile.interval;
        }
    }

    public void func_146273_a(int x, int y, int button, long timeSinceClicked) {
        super.func_146273_a(x, y, button, timeSinceClicked);
        if (this.isDragging) {
            this.tempHeightSetting = x - this.getLeft() - 38 - 4;
            if (this.tempHeightSetting < 0) {
                this.tempHeightSetting = 0;
            }
            if (this.tempHeightSetting > 79) {
                this.tempHeightSetting = 79;
            }
        }
    }

    public void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        if (this.isDragging) {
            MessageEmitterUpdate message = new MessageEmitterUpdate(1, this.tempHeightSetting);
            MessageHandler.INSATNCE.sendToServer((IMessage)message);
            this.tile.interval = this.tempHeightSetting;
            this.isDragging = false;
            this.syncGUIElements();
        }
    }

    protected void updateSliderPosition() {
        slider.setX(38 + (this.isDragging ? this.tempHeightSetting : this.tile.interval));
    }

    protected void syncGUIElements() {
        this.intervalPercent = (int)((float)this.tile.intervalReset / (float)((this.tile.interval + 1) * 20) * 200.0f);
        if (this.intervalPercent <= 100) {
            this.progressBar = (int)((float)this.intervalPercent * 0.7f);
            if (this.progressBar <= 7) {
                this.progressVertical = this.progressBar;
                this.progressHorizontal = 0;
            } else {
                this.progressVertical = 7;
                this.progressHorizontal = this.progressBar - 6;
            }
        } else {
            this.progressVertical = 7;
            this.progressHorizontal = 64;
        }
        this.burstOffset = this.intervalPercent >= 100 && this.intervalPercent <= 200 ? (int)((float)this.tile.intervalReset / (float)((this.tile.interval + 1) * 20) * 20.0f) - 11 : 0;
        this.guiParticle = this.intervalPercent <= 113 ? (int)((float)(this.intervalPercent - 100)) : 13;
        if (this.tile.interval <= 1) {
            this.guiParticle += 3;
        }
        this.fuelLoadVertical = 0;
        this.fuelLoadhorizontal = 0;
    }
}

