/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.koresample.tree.loader;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.scottkillen.mod.koresample.common.util.slab.SingleDoubleSlab;
import com.scottkillen.mod.koresample.common.util.slab.TheSingleSlabRegistry;
import com.scottkillen.mod.koresample.tree.DefinesLeaves;
import com.scottkillen.mod.koresample.tree.DefinesLog;
import com.scottkillen.mod.koresample.tree.DefinesSapling;
import com.scottkillen.mod.koresample.tree.DefinesSlab;
import com.scottkillen.mod.koresample.tree.DefinesStairs;
import com.scottkillen.mod.koresample.tree.DefinesWood;
import com.scottkillen.mod.koresample.tree.TreeBlockFactory;
import com.scottkillen.mod.koresample.tree.TreeTaxonomy;
import java.util.ArrayList;

public class TreeSpeciesLoader {
    private final TreeTaxonomy taxonomy;
    private final TheSingleSlabRegistry slabRegistry = TheSingleSlabRegistry.REFERENCE;

    public TreeSpeciesLoader(TreeTaxonomy taxonomy) {
        this.taxonomy = taxonomy;
    }

    public void load(TreeBlockFactory factory) {
        this.loadLogBlocks(factory);
        this.loadLeavesBlocks(factory);
        this.loadWoodBlocks(factory);
        this.loadSaplingBlocks(factory);
        this.loadSlabBlocks(factory);
        this.loadStairsBlocks(factory);
    }

    private void loadLeavesBlocks(TreeBlockFactory factory) {
        ArrayList subBlocks = Lists.newArrayListWithCapacity((int)4);
        for (DefinesLeaves definesLeaves : this.taxonomy.leavesDefinitions()) {
            definesLeaves.assignLeavesSubBlockIndex(subBlocks.size());
            subBlocks.add(definesLeaves);
            if (subBlocks.size() != 4) continue;
            factory.createLeavesBlock(subBlocks);
            subBlocks.clear();
        }
        if (!subBlocks.isEmpty()) {
            factory.createLeavesBlock(subBlocks);
        }
    }

    private void loadLogBlocks(TreeBlockFactory factory) {
        ArrayList subBlocks = Lists.newArrayListWithCapacity((int)4);
        for (DefinesLog definesLog : this.taxonomy.logDefinitions()) {
            definesLog.assignLogSubBlockIndex(subBlocks.size());
            subBlocks.add(definesLog);
            if (subBlocks.size() != 4) continue;
            factory.createLogBlock(subBlocks);
            subBlocks.clear();
        }
        if (!subBlocks.isEmpty()) {
            factory.createLogBlock(subBlocks);
        }
    }

    private void loadSaplingBlocks(TreeBlockFactory factory) {
        ArrayList subBlocks = Lists.newArrayListWithCapacity((int)8);
        for (DefinesSapling definesSapling : this.taxonomy.saplingDefinitions()) {
            definesSapling.assignSaplingSubBlockIndex(subBlocks.size());
            subBlocks.add(definesSapling);
            if (subBlocks.size() != 8) continue;
            factory.createSaplingBlock(subBlocks);
            subBlocks.clear();
        }
        if (!subBlocks.isEmpty()) {
            factory.createSaplingBlock(subBlocks);
        }
    }

    private void loadSlabBlocks(TreeBlockFactory factory) {
        ArrayList subBlocks = Lists.newArrayList();
        for (DefinesSlab definesSlab : this.taxonomy.slabDefinitions()) {
            definesSlab.assignSlabSubBlockIndex(subBlocks.size());
            subBlocks.add(definesSlab);
            if (subBlocks.size() != 8) continue;
            SingleDoubleSlab slabs = factory.createSlabBlocks(subBlocks);
            this.slabRegistry.add(slabs.singleSlab());
            subBlocks.clear();
        }
        if (!subBlocks.isEmpty()) {
            SingleDoubleSlab slabs = factory.createSlabBlocks(subBlocks);
            this.slabRegistry.add(slabs.singleSlab());
        }
    }

    private void loadStairsBlocks(TreeBlockFactory factory) {
        for (DefinesStairs definesStairs : this.taxonomy.stairsDefinitions()) {
            factory.createStairsBlock(definesStairs);
        }
    }

    private void loadWoodBlocks(TreeBlockFactory factory) {
        ArrayList subBlocks = Lists.newArrayListWithCapacity((int)16);
        for (DefinesWood definesWood : this.taxonomy.woodDefinitions()) {
            definesWood.assignWoodSubBlockIndex(subBlocks.size());
            subBlocks.add(definesWood);
            if (subBlocks.size() != 16) continue;
            factory.createWoodBlock(subBlocks);
            subBlocks.clear();
        }
        if (!subBlocks.isEmpty()) {
            factory.createWoodBlock(subBlocks);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("taxonomy", (Object)this.taxonomy).add("slabRegistry", (Object)this.slabRegistry).toString();
    }
}

