/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.koresample.tree.block;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.scottkillen.mod.koresample.tree.DefinesWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.BlockWood;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class WoodBlock
extends BlockWood {
    public static final int CAPACITY = 16;
    private final ImmutableList<DefinesWood> subBlocks;
    private final List<IIcon> icons = Lists.newArrayList();

    protected WoodBlock(Collection<? extends DefinesWood> subBlocks) {
        Preconditions.checkArgument((!subBlocks.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((subBlocks.size() <= 16 ? 1 : 0) != 0);
        this.subBlocks = ImmutableList.copyOf(subBlocks);
        this.func_149663_c("wood");
    }

    protected static String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(46) + 1);
    }

    protected final List<DefinesWood> subBlocks() {
        return Collections.unmodifiableList(this.subBlocks);
    }

    public final ImmutableList<String> getSubBlockNames() {
        ArrayList names = Lists.newArrayList();
        for (DefinesWood subBlock : this.subBlocks) {
            names.add(subBlock.speciesName());
        }
        return ImmutableList.copyOf((Collection)names);
    }

    public final String func_149739_a() {
        return String.format("tile.%s%s", this.resourcePrefix(), WoodBlock.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149691_a(int unused, int meta) {
        int meta1 = meta < 0 || meta >= this.icons.size() ? 0 : meta;
        return this.icons.get(meta1);
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149666_a(Item item, CreativeTabs unused, List subblocks) {
        for (int i = 0; i < this.subBlocks.size(); ++i) {
            subblocks.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149651_a(IIconRegister iconRegister) {
        this.icons.clear();
        for (int i = 0; i < this.subBlocks.size(); ++i) {
            String iconName = String.format("%splanks_%s", this.resourcePrefix(), ((DefinesWood)this.subBlocks.get(i)).speciesName());
            this.icons.add(i, iconRegister.func_94245_a(iconName));
        }
    }

    protected abstract String resourcePrefix();

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("subBlocks", this.subBlocks).add("icons", this.icons).toString();
    }
}

