/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.koresample.tree.block;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.scottkillen.mod.koresample.tree.DefinesLeaves;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class LeavesBlock
extends BlockLeaves {
    public static final int CAPACITY = 4;
    private static final int METADATA_MASK = 3;
    private final ImmutableList<DefinesLeaves> subBlocks;

    protected LeavesBlock(Collection<? extends DefinesLeaves> subBlocks) {
        Preconditions.checkArgument((!subBlocks.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((subBlocks.size() <= 4 ? 1 : 0) != 0);
        this.subBlocks = ImmutableList.copyOf(subBlocks);
        this.func_149663_c("leaves");
    }

    private static int mask(int metadata) {
        return metadata & 3;
    }

    protected static String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(46) + 1);
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isFancyGraphics() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    protected final List<DefinesLeaves> subBlocks() {
        return Collections.unmodifiableList(this.subBlocks);
    }

    @SideOnly(value=Side.CLIENT)
    public final int func_149741_i(int metadata) {
        return ((DefinesLeaves)this.subBlocks.get(LeavesBlock.mask(metadata))).getLeavesInventoryColor();
    }

    @SideOnly(value=Side.CLIENT)
    public final int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        int metadata = LeavesBlock.mask(blockAccess.func_72805_g(x, y, z));
        return ((DefinesLeaves)this.subBlocks.get(metadata)).getLeavesColor(blockAccess, x, y, z);
    }

    public final Item func_149650_a(int metadata, Random unused, int unused2) {
        return Item.func_150898_a((Block)((DefinesLeaves)this.subBlocks.get(LeavesBlock.mask(metadata))).saplingDefinition().saplingBlock());
    }

    public final int func_149692_a(int metadata) {
        return ((DefinesLeaves)this.subBlocks.get(LeavesBlock.mask(metadata))).saplingDefinition().saplingSubBlockIndex();
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean func_149662_c() {
        return !LeavesBlock.isFancyGraphics();
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149691_a(int unused, int metadata) {
        return this.field_150129_M[LeavesBlock.isFancyGraphics() ? 0 : 1][LeavesBlock.mask(metadata)];
    }

    public final String[] func_150125_e() {
        ArrayList names = Lists.newArrayList();
        for (DefinesLeaves subBlock : this.subBlocks) {
            names.add(subBlock.speciesName());
        }
        return names.toArray(new String[names.size()]);
    }

    public final String func_149739_a() {
        return String.format("tile.%s%s", this.resourcePrefix(), LeavesBlock.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    public final int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) & 3;
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149666_a(Item item, CreativeTabs unused, List subBlocks) {
        for (int i = 0; i < this.subBlocks.size(); ++i) {
            subBlocks.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149651_a(IIconRegister iconRegister) {
        this.field_150129_M[0] = new IIcon[this.subBlocks.size()];
        this.field_150129_M[1] = new IIcon[this.subBlocks.size()];
        for (int i = 0; i < this.subBlocks.size(); ++i) {
            String iconName = String.format("%sleaves_%s", this.resourcePrefix(), ((DefinesLeaves)this.subBlocks.get(i)).speciesName().replace('.', '_'));
            this.field_150129_M[0][i] = iconRegister.func_94245_a(iconName);
            this.field_150129_M[1][i] = iconRegister.func_94245_a(iconName + "_opaque");
        }
    }

    protected abstract String resourcePrefix();

    @SideOnly(value=Side.CLIENT)
    public final boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        Block block = blockAccess.func_147439_a(x, y, z);
        return (LeavesBlock.isFancyGraphics() || !block.equals((Object)this)) && (side == 0 && this.field_149760_C > 0.0 || side == 1 && this.field_149756_F < 1.0 || side == 2 && this.field_149754_D > 0.0 || side == 3 && this.field_149757_G < 1.0 || side == 4 && this.field_149759_B > 0.0 || side == 5 && this.field_149755_E < 1.0 || !blockAccess.func_147439_a(x, y, z).func_149662_c());
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("subBlocks", this.subBlocks).toString();
    }
}

