/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.koresample.common.util.log;

import com.google.common.base.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public final class Logger {
    private final org.apache.logging.log4j.Logger logger;

    private Logger(String modID) {
        this.logger = LogManager.getLogger((String)modID);
    }

    public static Logger forMod(String modID) {
        return new Logger(modID);
    }

    public void info(String format, Object ... args) {
        this.log(Level.INFO, format, args);
    }

    public void log(Level level, Throwable exception, String format, Object ... args) {
        this.logger.log(level, String.format(format, args), exception);
    }

    private void log(Level level, String format, Object ... data) {
        this.logger.log(level, String.format(format, data));
    }

    public void severe(String format, Object ... args) {
        this.log(Level.ERROR, format, args);
    }

    public void warning(String format, Object ... args) {
        this.log(Level.WARN, format, args);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("logger", (Object)this.logger).toString();
    }
}

