/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.koresample.common.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

public class WeightedSet<T>
implements Collection<T> {
    private final Random random;
    private final Multiset<T> elements = HashMultiset.create();

    public static <T> WeightedSet<T> newWeightedSet() {
        return new WeightedSet<T>();
    }

    public static <T> WeightedSet<T> newWeightedSet(Random random) {
        return new WeightedSet<T>(random);
    }

    public WeightedSet() {
        this(new Random());
    }

    public WeightedSet(Random random) {
        Preconditions.checkNotNull((Object)random, (Object)"Random generator is required.");
        this.random = random;
    }

    public T randomPick() {
        int pick = this.random.nextInt(this.elements.size());
        int count = 0;
        for (Object t : this.elements.elementSet()) {
            if ((count += this.elements.count(t)) < pick) continue;
            return (T)t;
        }
        return null;
    }

    public void setWeight(T t, int weight) {
        this.elements.setCount(t, weight);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray((Object[])a);
    }

    @Override
    public boolean add(T t) {
        return this.elements.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.elements.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof WeightedSet)) {
            return false;
        }
        WeightedSet that = (WeightedSet)o;
        return this.elements.equals(that.elements);
    }

    @Override
    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("random", (Object)this.random).add("elements", this.elements).toString();
    }
}

