/*
 * Decompiled with CFR 0.152.
 */
package com.piepenguin.rfwindmill.blocks;

import com.piepenguin.rfwindmill.blocks.ItemBlockRotorBlock;
import com.piepenguin.rfwindmill.lib.Util;
import com.piepenguin.rfwindmill.tileentities.TileEntityRotorBlock;
import com.piepenguin.rfwindmill.tileentities.TileEntityWindmillBlock;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class RotorBlock
extends BlockContainer {
    private static final int numIcons = 4;
    private IIcon[] icons;

    public RotorBlock() {
        super(Material.field_151573_f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c("rfwindmill_rotor");
        GameRegistry.registerBlock((Block)this, ItemBlockRotorBlock.class, (String)"rotor");
        this.icons = new IIcon[4];
    }

    public static String getMaterialName(int pRotorType) {
        switch (pRotorType) {
            default: {
                return "rotorIron";
            }
            case 1: {
                return Util.useThermalFoundation() ? "rotorElectrum" : "rotorGold";
            }
            case 2: {
                return Util.useThermalFoundation() ? "rotorSignalum" : "rotorNether";
            }
            case 3: 
        }
        return Util.useThermalFoundation() ? "rotorEnderium" : "rotorDiamond";
    }

    public void func_149651_a(IIconRegister pIconRegister) {
        for (int i = 0; i < 4; ++i) {
            this.icons[i] = pIconRegister.func_94245_a("rfwindmill:" + RotorBlock.getMaterialName(i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int pSide, int pMeta) {
        return this.icons[pMeta >> 2];
    }

    public int func_149692_a(int pMeta) {
        return pMeta;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World pWorld, int pMeta) {
        return new TileEntityRotorBlock();
    }

    public void func_149681_a(World pWorld, int pX, int pY, int pZ, int pSide, EntityPlayer pPlayer) {
        TileEntityRotorBlock rotorEntity = (TileEntityRotorBlock)pWorld.func_147438_o(pX, pY, pZ);
        if (rotorEntity != null) {
            ForgeDirection rotorDir = Util.intToDirection(rotorEntity.func_145832_p() & 3).getOpposite();
            int parentX = pX + rotorDir.offsetX;
            int parentY = pY + rotorDir.offsetY;
            int parentZ = pZ + rotorDir.offsetZ;
            TileEntityWindmillBlock windmillEntity = (TileEntityWindmillBlock)pWorld.func_147438_o(parentX, parentY, parentZ);
            windmillEntity.setRotor(-1, ForgeDirection.NORTH);
        }
        this.dismantle(pWorld, pX, pY, pZ);
    }

    public boolean func_149727_a(World pWorld, int pX, int pY, int pZ, EntityPlayer pPlayer, int pSide, float pDx, float pDy, float pDz) {
        if (pPlayer == null || pPlayer instanceof FakePlayer) {
            return false;
        }
        TileEntityRotorBlock rotorEntity = (TileEntityRotorBlock)pWorld.func_147438_o(pX, pY, pZ);
        if (rotorEntity != null) {
            ForgeDirection rotorDir = Util.intToDirection(rotorEntity.func_145832_p() & 3).getOpposite();
            int parentX = pX + rotorDir.offsetX;
            int parentY = pY + rotorDir.offsetY;
            int parentZ = pZ + rotorDir.offsetZ;
            TileEntityWindmillBlock windmillEntity = (TileEntityWindmillBlock)pWorld.func_147438_o(parentX, parentY, parentZ);
            if (windmillEntity != null) {
                windmillEntity.handcrank();
            }
        }
        return true;
    }

    public void dismantle(World pWorld, int pX, int pY, int pZ) {
        TileEntityRotorBlock entity = (TileEntityRotorBlock)pWorld.func_147438_o(pX, pY, pZ);
        ItemStack itemStack = new ItemStack((Item)entity.getRotorItem());
        pWorld.func_147468_f(pX, pY, pZ);
        EntityItem entityItem = new EntityItem(pWorld, (double)pX + 0.5, (double)pY + 0.5, (double)pZ + 0.5, itemStack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70179_y = 0.0;
        pWorld.func_72838_d((Entity)entityItem);
    }

    public static boolean canPlace(World pWorld, int pX, int pY, int pZ, EntityPlayer pPlayer, ForgeDirection pDir) {
        return pWorld.func_147437_c(pX, pY + 1, pZ) && pWorld.func_147437_c(pX, pY, pZ) && pWorld.func_147437_c(pX, pY - 1, pZ) && (pDir == ForgeDirection.NORTH || pDir == ForgeDirection.SOUTH ? pWorld.func_147437_c(pX - 1, pY + 1, pZ) && pWorld.func_147437_c(pX + 1, pY + 1, pZ) && pWorld.func_147437_c(pX - 1, pY, pZ) && pWorld.func_147437_c(pX + 1, pY, pZ) && pWorld.func_147437_c(pX - 1, pY - 1, pZ) && pWorld.func_147437_c(pX + 1, pY - 1, pZ) : pWorld.func_147437_c(pX, pY + 1, pZ - 1) && pWorld.func_147437_c(pX, pY + 1, pZ + 1) && pWorld.func_147437_c(pX, pY, pZ - 1) && pWorld.func_147437_c(pX, pY, pZ + 1) && pWorld.func_147437_c(pX, pY - 1, pZ - 1) && pWorld.func_147437_c(pX, pY - 1, pZ + 1));
    }
}

