/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.tanks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.util.FluidTankWrapper;
import elec332.core.util.NBTHelper;
import elec332.core.world.DimensionCoordinate;
import elec332.core.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.tanks.InternalGridTank;
import mcjty.deepresonance.tanks.TankTileLink;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TankGrid
implements IFluidHandler,
IFluidTank {
    public static final int TANK_BUCKETS = 16;
    private final Set<TankTileLink> tanks = Sets.newHashSet();
    private final Set<TankTileLink> tanks_ = Collections.unmodifiableSet(this.tanks);
    private Map<Integer, List<DimensionCoordinate>> renderData;
    private final InternalGridTank tank;
    private final FluidTankWrapper fluidTank;
    private boolean needsSorting;
    private Fluid lastSendFluid;
    private long lastHeightTime;
    private int i;

    public TankGrid(TankTileLink tank) {
        this.tanks.add(tank);
        this.tank = new InternalGridTank(16000);
        this.tank.fill(tank.getTileEntity().myTank, true);
        this.fluidTank = new FluidTankWrapper(){

            protected IFluidTank getTank() {
                return TankGrid.this.tank;
            }

            public int fill(FluidStack resource, boolean doFill) {
                return this.getTank().fill(resource, doFill);
            }
        };
        this.renderData = Maps.newHashMap();
        this.needsSorting = true;
    }

    public Set<TankTileLink> getConnections() {
        return this.tanks_;
    }

    public void tick() {
        if (this.i <= 0) {
            this.setTankFluidHeights(false);
            if (this.lastSendFluid != this.tank.getStoredFluid()) {
                this.markAllBlocksForUpdate();
            }
            this.setClientRenderFluid(true);
            this.i = 20;
        }
        --this.i;
    }

    protected boolean canMerge(TankGrid grid) {
        Fluid otherFluid;
        if (grid == this) {
            return false;
        }
        Fluid fluid = this.getStoredFluid();
        return fluid == (otherFluid = grid.getStoredFluid()) || fluid == null || otherFluid == null;
    }

    public void mergeWith(TankGrid grid) {
        for (TankTileLink tank : grid.tanks_) {
            tank.setGrid(this);
            this.tanks.add(tank);
        }
        this.tank.merge(grid.tank);
        this.needsSorting = true;
        this.setTankFluidHeights(false);
    }

    public void onRemoved(TankTileLink o) {
        FluidStack stack = this.getFluidShare(o.getTileEntity());
        this.setDataToTile(o.getTileEntity(), stack);
        o.setGrid(null);
    }

    public void invalidate() {
        this.renderData.clear();
        this.tanks.clear();
    }

    private void setTankFluidHeights(boolean fillDrain) {
        boolean sorted = false;
        if (this.needsSorting) {
            this.renderData.clear();
            ArrayList listT = Lists.newArrayList(this.tanks);
            Collections.sort(listT, (o1, o2) -> o1.getPosition().getPos().func_177956_o() - o2.getPosition().getPos().func_177956_o());
            for (TankTileLink loc : listT) {
                BlockPos p = loc.getPosition().getPos();
                ArrayList list = this.renderData.get(p.func_177956_o());
                if (list == null) {
                    list = Lists.newArrayList();
                    this.renderData.put(p.func_177956_o(), list);
                }
                list.add((DimensionCoordinate)loc.getPosition());
            }
            this.needsSorting = false;
            sorted = true;
        }
        long time = System.currentTimeMillis();
        if (sorted || fillDrain || time - this.lastHeightTime > 300L) {
            int total = this.tank.getFluidAmount();
            ArrayList list8776 = Lists.newArrayList(this.renderData.keySet());
            Collections.sort(list8776);
            for (Integer j : list8776) {
                List<DimensionCoordinate> list = this.renderData.get(j);
                float filled = 0.0f;
                if (total > 0) {
                    int i = list.size();
                    int toAdd = Math.min(total, i * 16 * 1000);
                    total -= toAdd;
                    filled = (float)toAdd / (float)(i * 16 * 1000);
                }
                for (DimensionCoordinate loc : list) {
                    TileTank tank = this.getTank(loc);
                    if (tank == null) continue;
                    tank.sendPacket(3, new NBTHelper().addToTag(filled, "render").serializeNBT());
                }
            }
            this.lastHeightTime = time;
        }
    }

    public void setDataToTile(TileTank tile) {
        this.setDataToTile(tile, this.getFluidShare(tile));
    }

    private void setDataToTile(TileTank tile, FluidStack share) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        Fluid lastSeenFluid = this.getStoredFluid();
        if (share != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            share.writeToNBT(fluidTag);
            tagCompound.func_74782_a("fluid", (NBTBase)fluidTag);
        }
        if (lastSeenFluid != null) {
            tagCompound.func_74778_a("lastSeenFluid", FluidRegistry.getFluidName((Fluid)lastSeenFluid));
        }
        tile.setSaveData(tagCompound);
        if (WorldHelper.chunkLoaded((World)tile.func_145831_w(), (BlockPos)tile.func_174877_v())) {
            tile.func_70296_d();
        }
    }

    public int getComparatorInputOverride() {
        float f = (float)this.tank.getFluidAmount() / (float)this.getCapacity();
        return (int)(f * 15.0f);
    }

    private FluidStack getFluidShare(TileTank tile) {
        return this.tank.getShare(this.tanks_.size(), this.tanks_.iterator().next().getPosition().equals((Object)DimensionCoordinate.fromTileEntity((TileEntity)tile)));
    }

    public Fluid getStoredFluid() {
        FluidStack fI = this.getFluid();
        return fI == null ? null : fI.getFluid();
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.fluidTank.getTankProperties();
    }

    @Nullable
    public FluidStack getFluid() {
        return this.fluidTank.getFluid();
    }

    public int getFluidAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public int getCapacity() {
        return this.fluidTank.getCapacity();
    }

    public FluidTankInfo getInfo() {
        return this.fluidTank.getInfo();
    }

    public int fill(FluidStack resource, boolean doFill) {
        int ret = this.fluidTank.fill(resource, doFill);
        if (doFill) {
            this.setClientRenderFluid(false);
            this.setTankFluidHeights(true);
            this.markDirty();
        }
        return ret;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack ret = this.fluidTank.drain(resource, doDrain);
        if (doDrain) {
            this.setClientRenderFluid(false);
            this.setTankFluidHeights(true);
            this.markDirty();
        }
        return ret;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack ret = this.fluidTank.drain(maxDrain, doDrain);
        if (doDrain) {
            this.setClientRenderFluid(false);
            this.setTankFluidHeights(true);
            this.markDirty();
        }
        return ret;
    }

    private void markAllBlocksForUpdate() {
        for (TankTileLink tank : this.tanks_) {
            WorldHelper.markBlockForUpdate((World)tank.getTileEntity().func_145831_w(), (BlockPos)tank.getPosition().getPos());
        }
    }

    private void markDirty() {
        for (TankTileLink tank : this.tanks_) {
            this.markDirty(tank.getTileEntity());
        }
    }

    private void markDirty(TileTank tank) {
        if (tank != null && WorldHelper.chunkLoaded((World)tank.func_145831_w(), (BlockPos)tank.func_174877_v())) {
            tank.func_70296_d();
        }
    }

    private void setClientRenderFluid(boolean force) {
        Fluid fluid = this.getStoredFluid();
        if (force || fluid != this.lastSendFluid) {
            for (TankTileLink tank : this.tanks_) {
                this.setClientRenderFluid(tank.getTileEntity(), fluid);
            }
            this.lastSendFluid = fluid;
        }
    }

    private void setClientRenderFluid(TileTank tank, Fluid fluid) {
        if (tank != null) {
            tank.lastSeenFluid = this.getStoredFluid();
            tank.sendPacket(2, new NBTHelper().addToTag(DRFluidRegistry.getFluidName(fluid), "fluid").serializeNBT());
        }
    }

    @Nullable
    private TileTank getTank(DimensionCoordinate coordinate) {
        TileEntity t;
        if (coordinate.isLoaded() && (t = coordinate.getTileEntity()) instanceof TileTank) {
            return (TileTank)t;
        }
        return null;
    }
}

