/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;
import vazkii.quark.world.feature.CrystalCaves;

public class CrystalCaveGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (random.nextInt(CrystalCaves.crystalCaveRarity) != 0) {
            return;
        }
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        for (int i = 15; i < 50; ++i) {
            BlockPos pos = new BlockPos(x, i, z);
            BlockPos belowPos = pos.func_177977_b();
            IBlockState state = world.func_180495_p(pos);
            IBlockState stateBelow = world.func_180495_p(belowPos);
            if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || stateBelow.func_177230_c() != Blocks.field_150348_b) continue;
            this.makeCrystalCaveAt(world, pos, random);
            return;
        }
    }

    public void makeCrystalCaveAt(World world, BlockPos source, Random rand) {
        int color2;
        double expandX = (rand.nextDouble() - 0.5) * 2.0;
        double expandY = (rand.nextDouble() - 0.5) * (double)0.1f;
        double expandZ = (rand.nextDouble() - 0.5) * 2.0;
        double curveAngle = rand.nextDouble() * Math.PI * 2.0;
        double curveRatio = rand.nextDouble() * 0.25 + 0.1;
        double curveX = Math.cos(curveAngle) * curveRatio;
        double curveY = (rand.nextFloat() - 0.5f) * 0.05f;
        double curveZ = Math.sin(curveAngle) * curveRatio;
        BlockPos hollowingCenter = source;
        Vec3d expansion = new Vec3d(expandX, expandY, expandZ).func_72432_b();
        Vec3d curvature = new Vec3d(curveX, curveY, curveZ);
        int color1 = rand.nextInt(8);
        while ((color2 = rand.nextInt(8)) == color1) {
        }
        IBlockState crystal1 = CrystalCaves.crystal.func_176203_a(color1);
        IBlockState crystal2 = CrystalCaves.crystal.func_176203_a(color2);
        int length = 12 + rand.nextInt(10);
        int size = 4 + rand.nextInt(3);
        for (int i = 0; i < length; ++i) {
            this.hollowOut(world, hollowingCenter, rand, size, crystal1, crystal2);
            BlockPos currentCenter = hollowingCenter;
            hollowingCenter = currentCenter.func_177963_a(expansion.field_72450_a * (double)size * 0.5, expansion.field_72448_b * (double)size * 0.5, expansion.field_72449_c * (double)size * 0.5);
            if (hollowingCenter.func_177956_o() < 10) {
                expansion = new Vec3d(expansion.field_72450_a, -expansion.field_72448_b, expansion.field_72449_c);
                curvature = new Vec3d(curvature.field_72450_a, -curvature.field_72448_b, curvature.field_72449_c);
                currentCenter = hollowingCenter.func_177963_a(expansion.field_72450_a * (double)size * 0.5, expansion.field_72448_b * (double)size * 0.5, expansion.field_72449_c * (double)size * 0.5);
            }
            expansion = expansion.func_178787_e(curvature).func_72432_b();
        }
    }

    private void hollowOut(World world, BlockPos source, Random rand, int width, IBlockState crystal1, IBlockState crystal2) {
        ArrayList<BlockPos> crystals = new ArrayList<BlockPos>();
        int max = width * width;
        for (int i = -width; i <= width; ++i) {
            for (int j = -width; j <= width; ++j) {
                for (int k = -width; k <= width; ++k) {
                    BlockPos pos = source.func_177982_a(i, j, k);
                    int dist = i * i + j * j + k * k;
                    if (dist < max) {
                        IBlockState state = world.func_180495_p(pos);
                        Block block = state.func_177230_c();
                        if (block.func_176195_g(state, world, pos) == -1.0f) continue;
                        world.func_175698_g(pos);
                        continue;
                    }
                    if (dist - 1 >= max) continue;
                    crystals.add(pos);
                }
            }
        }
        for (BlockPos pos : crystals) {
            IBlockState stateAt;
            if (rand.nextInt(3) == 0) {
                this.makeCrystal(world, pos, rand, rand.nextBoolean() ? crystal1 : crystal2);
                continue;
            }
            if (rand.nextInt(2) != 0 || (stateAt = world.func_180495_p(pos)).func_177230_c().isAir(stateAt, (IBlockAccess)world, pos) || stateAt.func_177230_c() == CrystalCaves.crystal) continue;
            IBlockState oreState = Blocks.field_150352_o.func_176223_P();
            if (rand.nextInt(3) == 0) {
                oreState = rand.nextInt(3) == 0 ? Blocks.field_150482_ag.func_176223_P() : Blocks.field_150412_bA.func_176223_P();
            }
            world.func_175656_a(pos, oreState);
        }
    }

    private void makeCrystal(World world, BlockPos source, Random rand, IBlockState crystal) {
        IBlockState stateAt;
        Block block;
        boolean up = rand.nextBoolean();
        EnumFacing shift = up ? EnumFacing.UP : EnumFacing.DOWN;
        BlockPos startPos = source;
        IBlockState state = world.func_180495_p(startPos);
        if (state.func_177230_c() == CrystalCaves.crystal) {
            return;
        }
        int tests = 0;
        while (state.func_177230_c().isAir(state, (IBlockAccess)world, startPos)) {
            startPos = startPos.func_177972_a(shift.func_176734_d());
            state = world.func_180495_p(startPos);
            if (++tests < 10) continue;
            return;
        }
        int size = 3 + rand.nextInt(4);
        BlockPos pos = startPos;
        for (int i = 0; i < size && (block = (stateAt = world.func_180495_p(pos)).func_177230_c()).func_176195_g(stateAt, world, pos) != -1.0f; ++i) {
            world.func_175656_a(pos, crystal);
            pos = pos.func_177972_a(shift);
        }
    }
}

