/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import vazkii.quark.world.feature.Basalt;

public class BasaltGenerator
implements IWorldGenerator {
    boolean nether;
    boolean overworld;
    int clusterCountOverworld;
    int clusterCountNether;
    WorldGenMinable generatorOverworld;
    WorldGenMinable generatorNether;

    public BasaltGenerator(boolean nether, boolean overworld, int clusterSizeOverworld, int clusterSizeNether, int clusterCountOverworld, int clusterCountNether) {
        this.nether = nether;
        this.overworld = overworld;
        this.clusterCountNether = clusterCountNether;
        this.clusterCountOverworld = clusterCountOverworld;
        this.generatorOverworld = new WorldGenMinable(Basalt.basalt.func_176223_P(), clusterSizeOverworld);
        this.generatorNether = new WorldGenMinable(Basalt.basalt.func_176223_P(), clusterSizeNether, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        boolean isOverworld;
        boolean isNether = world.field_73011_w.func_186058_p() == DimensionType.NETHER;
        boolean bl = isOverworld = world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD;
        if (isNether && !this.nether || isOverworld && !this.overworld || !isNether && !isOverworld) {
            return;
        }
        for (int i = 0; i < (isNether ? this.clusterCountNether : this.clusterCountOverworld); ++i) {
            int x = chunkX * 16 + rand.nextInt(16);
            int y = rand.nextInt(isNether ? 128 : 80);
            int z = chunkZ * 16 + rand.nextInt(16);
            if (isNether) {
                this.generatorNether.func_180709_b(world, rand, new BlockPos(x, y, z));
                continue;
            }
            this.generatorOverworld.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

