/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityFurnaceHeater
extends TileEntityIEBase
implements ITickable,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IDirectionalTile {
    public FluxStorage energyStorage = new FluxStorage(32000, Math.max(256, Math.max(Config.IEConfig.Machines.heater_consumption, Config.IEConfig.Machines.heater_speedupConsumption)));
    public boolean active = false;
    public EnumFacing facing = EnumFacing.NORTH;
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, this.facing);

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean redstonePower;
            boolean a = this.active;
            boolean bl = redstonePower = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
            if (this.active && !redstonePower) {
                this.active = false;
            }
            if (this.energyStorage.getEnergyStored() > 3200 || a) {
                for (EnumFacing fd : EnumFacing.field_82609_l) {
                    TileEntity tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(fd));
                    int consumed = 0;
                    if (tileEntity != null) {
                        if (tileEntity instanceof ExternalHeaterHandler.IExternalHeatable) {
                            consumed = ((ExternalHeaterHandler.IExternalHeatable)tileEntity).doHeatTick(this.energyStorage.getEnergyStored(), redstonePower);
                        } else {
                            ExternalHeaterHandler.HeatableAdapter adapter = ExternalHeaterHandler.getHeatableAdapter(tileEntity.getClass());
                            if (adapter != null) {
                                consumed = adapter.doHeatTick(tileEntity, this.energyStorage.getEnergyStored(), redstonePower);
                            }
                        }
                    }
                    if (consumed <= 0) continue;
                    this.energyStorage.extractEnergy(consumed, false);
                    if (this.active) continue;
                    this.active = true;
                }
            }
            if (this.active != a) {
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
                this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.active ? 1 : 0);
            }
        }
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return inf == IEBlockInterfaces.IActiveState.class ? IEProperties.BOOLEANS[0] : null;
    }

    @Override
    public boolean getIsActive() {
        return this.active || this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 1) {
            this.active = arg == 1;
        }
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.active = nbt.func_74767_n("active");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74757_a("active", this.active);
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return facing == this.facing ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (facing == this.facing) {
            if (this.wrapper.side != this.facing) {
                this.wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, this.facing);
            }
            return this.wrapper;
        }
        return null;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 1;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return placer.func_70093_af();
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }
}

