/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.AdvancedAABB;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityFluidPipe
extends TileEntityIEBase
implements IFluidPipe,
IEBlockInterfaces.IAdvancedHasObjProperty,
IOBJModelCallback<IBlockState>,
IEBlockInterfaces.IColouredTile,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdditionalDrops {
    static ConcurrentHashMap<BlockPos, Set<DirectionalFluidOutput>> indirectConnections = new ConcurrentHashMap();
    public static ArrayList<Function<ItemStack, Boolean>> validPipeCovers = new ArrayList();
    public static ArrayList<Function<ItemStack, Boolean>> climbablePipeCovers = new ArrayList();
    public int[] sideConfig = new int[]{0, 0, 0, 0, 0, 0};
    public ItemStack pipeCover = null;
    PipeFluidHandler[] sidedHandlers = new PipeFluidHandler[]{new PipeFluidHandler(this, EnumFacing.DOWN), new PipeFluidHandler(this, EnumFacing.UP), new PipeFluidHandler(this, EnumFacing.NORTH), new PipeFluidHandler(this, EnumFacing.SOUTH), new PipeFluidHandler(this, EnumFacing.WEST), new PipeFluidHandler(this, EnumFacing.EAST)};
    public static HashMap<String, OBJModel.OBJState> cachedOBJStates;
    static String[] CONNECTIONS;

    public static Set<DirectionalFluidOutput> getConnectedFluidHandlers(BlockPos node, World world) {
        if (indirectConnections.containsKey(node)) {
            return indirectConnections.get(node);
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        Set<DirectionalFluidOutput> fluidHandlers = Collections.newSetFromMap(new ConcurrentHashMap());
        openList.add(node);
        while (!openList.isEmpty() && closedList.size() < 1024) {
            BlockPos next = (BlockPos)openList.get(0);
            if (world.func_175667_e(next)) {
                TileEntity pipeTile = world.func_175625_s(next);
                if (!closedList.contains(next) && pipeTile instanceof IFluidPipe) {
                    if (pipeTile instanceof TileEntityFluidPipe) {
                        closedList.add(next);
                    }
                    for (int i = 0; i < 6; ++i) {
                        IFluidHandler handler;
                        IFluidTankProperties[] tankInfo;
                        TileEntity adjacentTile;
                        BlockPos nextPos;
                        EnumFacing fd = EnumFacing.func_82600_a((int)i);
                        if (!((IFluidPipe)pipeTile).hasOutputConnection(fd) || !world.func_175667_e(nextPos = next.func_177972_a(fd)) || (adjacentTile = world.func_175625_s(nextPos)) == null) continue;
                        if (adjacentTile instanceof TileEntityFluidPipe) {
                            openList.add(nextPos);
                            continue;
                        }
                        if (!adjacentTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, fd.func_176734_d()) || (tankInfo = (handler = (IFluidHandler)adjacentTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, fd.func_176734_d())).getTankProperties()) == null || tankInfo.length <= 0) continue;
                        fluidHandlers.add(new DirectionalFluidOutput(handler, adjacentTile, fd));
                    }
                }
            }
            openList.remove(0);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !indirectConnections.containsKey(node)) {
            indirectConnections.put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
            indirectConnections.get(node).addAll(fluidHandlers);
        }
        return fluidHandlers;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            indirectConnections.clear();
        }
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (!(entity instanceof EntityLivingBase) || ((EntityLivingBase)entity).func_70617_f_() || this.pipeCover == null) {
            return;
        }
        boolean climb = false;
        for (Function<ItemStack, Boolean> f : climbablePipeCovers) {
            if (f == null || f.apply((Object)this.pipeCover) != Boolean.TRUE) continue;
            climb = true;
            break;
        }
        if (!climb) {
            return;
        }
        float f5 = 0.15f;
        if (entity.field_70159_w < (double)(-f5)) {
            entity.field_70159_w = -f5;
        }
        if (entity.field_70159_w > (double)f5) {
            entity.field_70159_w = f5;
        }
        if (entity.field_70179_y < (double)(-f5)) {
            entity.field_70179_y = -f5;
        }
        if (entity.field_70179_y > (double)f5) {
            entity.field_70179_y = f5;
        }
        entity.field_70143_R = 0.0f;
        if (entity.field_70181_x < -0.15) {
            entity.field_70181_x = -0.15;
        }
        if (entity.field_70181_x < 0.0 && entity instanceof EntityPlayer && entity.func_70093_af()) {
            entity.field_70181_x = 0.05;
            return;
        }
        if (entity.field_70123_F) {
            entity.field_70181_x = 0.2;
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.func_74759_k("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length != 6) {
            this.sideConfig = new int[]{0, 0, 0, 0, 0, 0};
        }
        this.pipeCover = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("pipeCover"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideConfig", this.sideConfig);
        if (this.pipeCover != null) {
            nbt.func_74782_a("pipeCover", (NBTBase)this.pipeCover.func_77955_b(new NBTTagCompound()));
        }
    }

    boolean canOutputPressurized(TileEntity output, boolean consumePower) {
        if (output instanceof IFluidPipe) {
            return ((IFluidPipe)output).canOutputPressurized(consumePower);
        }
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && this.sideConfig[facing.ordinal()] == 0) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && this.sideConfig[facing.ordinal()] == 0) {
            return (T)this.sidedHandlers[facing.ordinal()];
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureReplacement(IBlockState object, String material) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(IBlockState object, String group) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Matrix4 handlePerspective(IBlockState Object2, ItemCameraTransforms.TransformType cameraTransformType, Matrix4 perspective) {
        return perspective;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(IBlockState object, List<BakedQuad> quads) {
        if (this.pipeCover != null) {
            Block b = Block.func_149634_a((Item)this.pipeCover.func_77973_b());
            IBlockState state = b != null ? b.func_176203_a(this.pipeCover.func_77960_j()) : Blocks.field_150348_b.func_176223_P();
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
            if (model != null) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    quads.addAll(model.func_188616_a(state, facing, 0L));
                }
                quads.addAll(model.func_188616_a(state, null, 0L));
            }
        }
        return quads;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getCacheKey(IBlockState object) {
        return this.getRenderCacheKey();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Optional<TRSRTransformation> applyTransformations(IBlockState object, String group, Optional<TRSRTransformation> transform) {
        return transform;
    }

    @Override
    public Collection<ItemStack> getExtraDrops(EntityPlayer player, IBlockState state) {
        if (this.pipeCover != null) {
            return Lists.newArrayList((Object[])new ItemStack[]{this.pipeCover});
        }
        return null;
    }

    public byte getConnectionByte() {
        byte connections = 0;
        for (int i = 5; i >= 0; --i) {
            IFluidHandler handler;
            IFluidTankProperties[] tankInfo;
            EnumFacing dir = EnumFacing.func_82600_a((int)i);
            TileEntity con = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            connections = (byte)(connections << 1);
            if (this.sideConfig[i] != 0 || con == null || !con.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d()) || (tankInfo = (handler = (IFluidHandler)con.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())).getTankProperties()) == null || tankInfo.length <= 0) continue;
            connections = (byte)(connections | 1);
        }
        return connections;
    }

    public byte getAvailableConnectionByte() {
        byte connections = 0;
        for (int i = 5; i >= 0; --i) {
            IFluidHandler handler;
            IFluidTankProperties[] tankInfo;
            EnumFacing dir = EnumFacing.func_82600_a((int)i);
            TileEntity con = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            connections = (byte)(connections << 1);
            if (con == null || !con.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d()) || (tankInfo = (handler = (IFluidHandler)con.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())).getTankProperties()) == null || tankInfo.length <= 0) continue;
            connections = (byte)(connections | 1);
        }
        return connections;
    }

    public int getConnectionStyle(int connection) {
        byte tileConnections;
        if (this.sideConfig[connection] == -1) {
            return 0;
        }
        byte thisConnections = this.getConnectionByte();
        if ((thisConnections & 1 << connection) == 0) {
            return 0;
        }
        if (thisConnections != 3 && thisConnections != 12 && thisConnections != 48) {
            return 1;
        }
        TileEntity con = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.func_82600_a((int)connection)));
        if (con instanceof TileEntityFluidPipe && thisConnections == (tileConnections = ((TileEntityFluidPipe)con).getConnectionByte())) {
            return 0;
        }
        return 1;
    }

    public void toggleSide(int side) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 0) {
            this.sideConfig[side] = -1;
        }
        this.func_70296_d();
        EnumFacing fd = EnumFacing.func_82600_a((int)side);
        TileEntity connected = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(fd));
        if (connected instanceof TileEntityFluidPipe) {
            ((TileEntityFluidPipe)connected).sideConfig[fd.func_176734_d().ordinal()] = this.sideConfig[side];
            connected.func_70296_d();
            this.field_145850_b.func_175641_c(this.func_174877_v().func_177972_a(fd), this.func_145838_q(), 0, 0);
        }
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        ArrayList list = Lists.newArrayList();
        if (this.pipeCover != null) {
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186662_g(-0.03125).func_186670_a(this.func_174877_v()));
            return list;
        }
        byte connections = this.getConnectionByte();
        if (connections == 48) {
            list.add(new AxisAlignedBB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75).func_186670_a(this.func_174877_v()));
            if ((connections & 0x10) == 0) {
                list.add(new AxisAlignedBB(0.0, 0.125, 0.125, 0.125, 0.875, 0.875).func_186670_a(this.func_174877_v()));
            }
            if ((connections & 0x20) == 0) {
                list.add(new AxisAlignedBB(0.875, 0.125, 0.125, 1.0, 0.875, 0.875).func_186670_a(this.func_174877_v()));
            }
        } else if (connections == 12) {
            list.add(new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0).func_186670_a(this.func_174877_v()));
            if ((connections & 4) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.125).func_186670_a(this.func_174877_v()));
            }
            if ((connections & 8) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.125, 0.875, 0.875, 0.875, 1.0).func_186670_a(this.func_174877_v()));
            }
        } else if (connections == 3) {
            list.add(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75).func_186670_a(this.func_174877_v()));
            if ((connections & 1) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875).func_186670_a(this.func_174877_v()));
            }
            if ((connections & 2) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.875, 0.125, 0.875, 1.0, 0.875).func_186670_a(this.func_174877_v()));
            }
        } else {
            list.add(new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75).func_186670_a(this.func_174877_v()));
            for (int i = 0; i < 6; ++i) {
                if ((connections & 1) == 1) {
                    list.add(new AxisAlignedBB(i == 4 ? 0.0 : (i == 5 ? 0.875 : 0.125), i == 0 ? 0.0 : (i == 1 ? 0.875 : 0.125), i == 2 ? 0.0 : (i == 3 ? 0.875 : 0.125), i == 4 ? 0.125 : (i == 5 ? 1.0 : 0.875), i == 0 ? 0.125 : (i == 1 ? 1.0 : 0.875), i == 2 ? 0.125 : (i == 3 ? 1.0 : 0.875)).func_186670_a(this.func_174877_v()));
                }
                connections = (byte)(connections >> 1);
            }
        }
        return list;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        double[] dArray;
        ArrayList list = Lists.newArrayList();
        byte connections = this.getAvailableConnectionByte();
        byte availableConnections = this.getConnectionByte();
        if (this.pipeCover != null) {
            double[] dArray2 = new double[6];
            dArray2[0] = 0.002;
            dArray2[1] = 0.998;
            dArray2[2] = 0.002;
            dArray2[3] = 0.998;
            dArray2[4] = 0.002;
            dArray = dArray2;
            dArray2[5] = 0.998;
        } else {
            double[] dArray3 = new double[6];
            dArray3[0] = 0.25;
            dArray3[1] = 0.75;
            dArray3[2] = 0.25;
            dArray3[3] = 0.75;
            dArray3[4] = 0.25;
            dArray = dArray3;
            dArray3[5] = 0.75;
        }
        double[] baseAABB = dArray;
        for (int i = 0; i < 6; ++i) {
            double size;
            double depth = this.getConnectionStyle(i) == 0 ? 0.25 : 0.125;
            double d = size = this.getConnectionStyle(i) == 0 ? 0.25 : 0.125;
            if ((connections & 1) == 1) {
                list.add(new AdvancedAABB(new AxisAlignedBB(i == 4 ? 0.0 : (i == 5 ? 1.0 - depth : size), i == 0 ? 0.0 : (i == 1 ? 1.0 - depth : size), i == 2 ? 0.0 : (i == 3 ? 1.0 - depth : size), i == 4 ? depth : (i == 5 ? 1.0 : 1.0 - size), i == 0 ? depth : (i == 1 ? 1.0 : 1.0 - size), i == 2 ? depth : (i == 3 ? 1.0 : 1.0 - size)).func_186670_a(this.func_174877_v()), EnumFacing.func_82600_a((int)i)));
            }
            if ((availableConnections & 1) == 1) {
                int n = i;
                baseAABB[n] = baseAABB[n] + (i % 2 == 1 ? 0.125 : -0.125);
            }
            baseAABB[i] = Math.min(Math.max(baseAABB[i], 0.0), 1.0);
            availableConnections = (byte)(availableConnections >> 1);
            connections = (byte)(connections >> 1);
        }
        list.add(new AdvancedAABB(new AxisAlignedBB(baseAABB[4], baseAABB[0], baseAABB[2], baseAABB[5], baseAABB[1], baseAABB[3]).func_186670_a(this.func_174877_v()), null));
        return list;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        if (box instanceof AdvancedAABB && box.func_72314_b(0.002, 0.002, 0.002).func_72318_a(mop.field_72307_f)) {
            AxisAlignedBB changedBox = ((AdvancedAABB)box).fd != null ? box.func_72314_b(((AdvancedAABB)box).fd.func_82601_c() != 0 ? 0.0 : 0.03125, ((AdvancedAABB)box).fd.func_96559_d() != 0 ? 0.0 : 0.03125, ((AdvancedAABB)box).fd.func_82599_e() != 0 ? 0.0 : 0.03125) : box;
            list.add(changedBox);
            return true;
        }
        return false;
    }

    String getRenderCacheKey() {
        byte connections = this.getConnectionByte();
        String key = "";
        for (int i = 0; i < 6; ++i) {
            key = (connections & 1 << i) != 0 ? key + (this.getConnectionStyle(i) == 1 ? "2" : "1") : key + "0";
        }
        if (this.pipeCover != null) {
            key = key + "scaf:" + this.pipeCover.func_77973_b().getRegistryName();
        }
        return key;
    }

    @Override
    public OBJModel.OBJState getOBJState() {
        byte connections = this.getConnectionByte();
        String key = this.getRenderCacheKey();
        if (!cachedOBJStates.containsKey(key)) {
            ArrayList<String> parts = new ArrayList<String>();
            Matrix4 rotationMatrix = new Matrix4(TRSRTransformation.identity().getMatrix());
            int totalConnections = Integer.bitCount(connections);
            boolean straightY = (connections & 3) == 3;
            boolean straightZ = (connections & 0xC) == 12;
            boolean straightX = (connections & 0x30) == 48;
            switch (totalConnections) {
                case 0: {
                    parts.add("center");
                    break;
                }
                case 1: {
                    parts.add("stopper");
                    if ((connections & 2) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                    } else if ((connections & 4) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 8) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    } else if ((connections & 0x20) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    }
                    parts.add("con_yMin");
                    break;
                }
                case 2: {
                    if (straightY) {
                        parts.add("pipe_y");
                        if (this.getConnectionStyle(0) == 1) {
                            parts.add("con_yMin");
                        }
                        if (this.getConnectionStyle(1) != 1) break;
                        parts.add("con_yMax");
                        break;
                    }
                    if (straightZ) {
                        parts.add("pipe_z");
                        if (this.getConnectionStyle(2) == 1) {
                            parts.add("con_zMin");
                        }
                        if (this.getConnectionStyle(3) != 1) break;
                        parts.add("con_zMax");
                        break;
                    }
                    if (straightX) {
                        parts.add("pipe_x");
                        if (this.getConnectionStyle(4) == 1) {
                            parts.add("con_xMin");
                        }
                        if (this.getConnectionStyle(5) != 1) break;
                        parts.add("con_xMax");
                        break;
                    }
                    parts.add("curve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    byte connectTo = (byte)(connections & 0x3C);
                    if ((connections & 3) != 0) {
                        if (connectTo == 16) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 32) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 8) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    if (connectTo == 40) {
                        rotationMatrix.rotate(Math.PI, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo == 24) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo != 36) break;
                    rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    if (straightX || straightZ || straightY) {
                        parts.add("tcross");
                        parts.add("con_yMin");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (straightX) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                            if ((connections & 4) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 2) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                            if ((connections & 0x10) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 0x20) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x20) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    parts.add("tcurve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_xMax");
                    if ((connections & 8) != 0) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        } else {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        }
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 4: {
                    boolean cross;
                    boolean bl = cross = straightX && straightZ || straightX && straightY || straightZ && straightY;
                    if (cross) {
                        parts.add("cross");
                        parts.add("con_yMin");
                        parts.add("con_yMax");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (!straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        break;
                    }
                    parts.add("tcross2");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (straightY) {
                        rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                        if ((connections & 8) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) == 0) break;
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 5: {
                    parts.add("tcross3");
                    parts.add("con_yMin");
                    parts.add("con_yMax");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if (straightY) {
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate((connections & 2) != 0 ? 1.5707963267948966 : -1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (!straightX) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) == 0) break;
                    rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    break;
                }
                case 6: {
                    parts.add("con_yMin");
                    parts.add("con_yMax");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMin");
                    parts.add("con_xMax");
                }
            }
            Matrix4 tempMatr = new Matrix4();
            tempMatr.m23 = 0.5;
            tempMatr.m13 = 0.5;
            tempMatr.m03 = 0.5;
            rotationMatrix.leftMultiply(tempMatr);
            tempMatr.invert();
            rotationMatrix = rotationMatrix.multiply(tempMatr);
            cachedOBJStates.put(key, new OBJModel.OBJState(parts, true, (IModelState)new TRSRTransformation(rotationMatrix.toMatrix4f())));
        }
        return cachedOBJStates.get(key);
    }

    public static OBJModel.OBJState getStateFromKey(String key) {
        if (!cachedOBJStates.containsKey(key)) {
            ArrayList<String> parts = new ArrayList<String>();
            Matrix4 rotationMatrix = new Matrix4(TRSRTransformation.identity().getMatrix());
            byte connections = (byte)Integer.parseInt(key.replace("2", "1"), 2);
            int totalConnections = Integer.bitCount(connections);
            boolean straightY = (connections & 3) == 3;
            boolean straightZ = (connections & 0xC) == 12;
            boolean straightX = (connections & 0x30) == 48;
            switch (totalConnections) {
                case 0: {
                    parts.add("center");
                    break;
                }
                case 1: {
                    parts.add("stopper");
                    if ((connections & 2) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                    } else if ((connections & 4) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 8) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    } else if ((connections & 0x20) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    }
                    parts.add("con_yMin");
                    break;
                }
                case 2: {
                    if (straightY) {
                        parts.add("pipe_y");
                        if (key.charAt(5) == '2') {
                            parts.add("con_yMin");
                        }
                        if (key.charAt(4) != '\u0001') break;
                        parts.add("con_yMax");
                        break;
                    }
                    if (straightZ) {
                        parts.add("pipe_z");
                        if (key.charAt(3) == '2') {
                            parts.add("con_zMin");
                        }
                        if (key.charAt(2) != '2') break;
                        parts.add("con_zMax");
                        break;
                    }
                    if (straightX) {
                        parts.add("pipe_x");
                        if (key.charAt(1) == '2') {
                            parts.add("con_xMin");
                        }
                        if (key.charAt(0) != '2') break;
                        parts.add("con_xMax");
                        break;
                    }
                    parts.add("curve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    byte connectTo = (byte)(connections & 0x3C);
                    if ((connections & 3) != 0) {
                        if (connectTo == 16) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 32) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 8) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    if (connectTo == 40) {
                        rotationMatrix.rotate(Math.PI, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo == 24) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo != 36) break;
                    rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    if (straightX || straightZ || straightY) {
                        parts.add("tcross");
                        parts.add("con_yMin");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (straightX) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                            if ((connections & 4) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 2) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                            if ((connections & 0x10) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 0x20) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x20) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    parts.add("tcurve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_xMax");
                    if ((connections & 8) != 0) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        } else {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        }
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 4: {
                    boolean cross;
                    boolean bl = cross = straightX && straightZ || straightX && straightY || straightZ && straightY;
                    if (cross) {
                        parts.add("cross");
                        parts.add("con_yMin");
                        parts.add("con_yMax");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (!straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        break;
                    }
                    parts.add("tcross2");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (straightY) {
                        if ((connections & 8) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) == 0) break;
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 5: {
                    parts.add("tcross3");
                    parts.add("con_yMin");
                    parts.add("con_yMax");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if (straightY) {
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate((connections & 2) != 0 ? 1.5707963267948966 : -1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (!straightX) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) == 0) break;
                    rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    break;
                }
            }
            Matrix4 tempMatr = new Matrix4();
            tempMatr.m23 = 0.5;
            tempMatr.m13 = 0.5;
            tempMatr.m03 = 0.5;
            rotationMatrix.leftMultiply(tempMatr);
            tempMatr.invert();
            rotationMatrix = rotationMatrix.multiply(tempMatr);
            cachedOBJStates.put(key, new OBJModel.OBJState(parts, true, (IModelState)new TRSRTransformation(rotationMatrix.toMatrix4f())));
        }
        return cachedOBJStates.get(key);
    }

    @Override
    public int getRenderColour(int tintIndex) {
        return 0xFFFFFF;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (heldItem == null && player.func_70093_af() && this.pipeCover != null) {
            EntityItem entityitem;
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82736_K().func_82766_b("doTileDrops") && (entityitem = player.func_71019_a(this.pipeCover.func_77946_l(), false)) != null) {
                entityitem.func_174868_q();
            }
            this.pipeCover = null;
            this.markContainingBlockForUpdate(null);
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 255, 0);
            return true;
        }
        if (heldItem != null && !player.func_70093_af()) {
            for (Function<ItemStack, Boolean> func : validPipeCovers) {
                EntityItem entityitem;
                if (func.apply((Object)heldItem) != Boolean.TRUE || OreDictionary.itemMatches((ItemStack)this.pipeCover, (ItemStack)heldItem, (boolean)true)) continue;
                if (!this.field_145850_b.field_72995_K && this.pipeCover != null && this.field_145850_b.func_82736_K().func_82766_b("doTileDrops") && (entityitem = player.func_71019_a(this.pipeCover.func_77946_l(), false)) != null) {
                    entityitem.func_174868_q();
                }
                this.pipeCover = Utils.copyStackWithAmount(heldItem, 1);
                if (--heldItem.field_77994_a <= 0) {
                    heldItem = null;
                }
                this.markContainingBlockForUpdate(null);
                this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 255, 0);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        EnumFacing fd = side;
        List<AxisAlignedBB> boxes = this.getAdvancedSelectionBounds();
        for (AxisAlignedBB box : boxes) {
            if (!(box instanceof AdvancedAABB) || !box.func_72314_b(0.002, 0.002, 0.002).func_72318_a(new Vec3d((double)((float)this.func_174877_v().func_177958_n() + hitX), (double)((float)this.func_174877_v().func_177956_o() + hitY), (double)((float)this.func_174877_v().func_177952_p() + hitZ))) || !(box instanceof AdvancedAABB) || ((AdvancedAABB)box).fd == null) continue;
            fd = ((AdvancedAABB)box).fd;
        }
        if (fd != null) {
            this.toggleSide(fd.ordinal());
            this.markContainingBlockForUpdate(null);
            indirectConnections.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean canOutputPressurized(boolean consumePower) {
        return false;
    }

    @Override
    public boolean hasOutputConnection(EnumFacing side) {
        return side != null && this.sideConfig[side.ordinal()] == 0;
    }

    static {
        final ArrayList scaffolds = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)IEContent.blockWoodenDecoration, 1, BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_1.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_2.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_0.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_1.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_2.getMeta())});
        validPipeCovers.add(new Function<ItemStack, Boolean>(){

            @Nullable
            public Boolean apply(@Nullable ItemStack input) {
                if (input == null) {
                    return Boolean.FALSE;
                }
                for (ItemStack stack : scaffolds) {
                    if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)input, (boolean)false)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        climbablePipeCovers.add(new Function<ItemStack, Boolean>(){

            @Nullable
            public Boolean apply(@Nullable ItemStack input) {
                if (input == null) {
                    return Boolean.FALSE;
                }
                for (ItemStack stack : scaffolds) {
                    if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)input, (boolean)false)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        cachedOBJStates = new HashMap();
        CONNECTIONS = new String[]{"con_yMin", "con_yMax", "con_zMin", "con_zMax", "con_xMin", "con_xMax"};
    }

    public static class DirectionalFluidOutput {
        IFluidHandler output;
        EnumFacing direction;
        TileEntity containingTile;

        public DirectionalFluidOutput(IFluidHandler output, TileEntity containingTile, EnumFacing direction) {
            this.output = output;
            this.direction = direction;
            this.containingTile = containingTile;
        }
    }

    static class PipeFluidHandler
    implements IFluidHandler {
        TileEntityFluidPipe pipe;
        EnumFacing facing;

        public PipeFluidHandler(TileEntityFluidPipe pipe, EnumFacing facing) {
            this.pipe = pipe;
            this.facing = facing;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(null, 1000, true, false)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            int limit;
            int tileSpecificAcceptedFluid;
            if (resource == null) {
                return 0;
            }
            int canAccept = resource.amount;
            if (canAccept <= 0) {
                return 0;
            }
            ArrayList<DirectionalFluidOutput> outputList = new ArrayList<DirectionalFluidOutput>(TileEntityFluidPipe.getConnectedFluidHandlers(this.pipe.func_174877_v(), this.pipe.field_145850_b));
            BlockPos ccFrom2 = new BlockPos((Vec3i)this.pipe.func_174877_v().func_177972_a(this.facing));
            if (outputList.size() < 1) {
                return 0;
            }
            BlockPos ccFrom = new BlockPos((Vec3i)this.pipe.func_174877_v().func_177972_a(this.facing));
            int sum = 0;
            HashMap<DirectionalFluidOutput, Integer> sorting = new HashMap<DirectionalFluidOutput, Integer>();
            for (DirectionalFluidOutput output : outputList) {
                int temp;
                BlockPos cc = Utils.toCC(output.containingTile);
                if (cc.equals((Object)ccFrom) || !this.pipe.field_145850_b.func_175667_e(cc) || this.pipe.equals(output.containingTile) || (temp = output.output.fill(Utils.copyFluidStackWithAmount(resource, tileSpecificAcceptedFluid = Math.min(limit = resource.tag != null && resource.tag.func_74764_b("pressurized") || this.pipe.canOutputPressurized(output.containingTile, false) ? 1000 : 50, canAccept), true), false)) <= 0) continue;
                sorting.put(output, temp);
                sum += temp;
            }
            if (sum > 0) {
                int f = 0;
                for (DirectionalFluidOutput output : sorting.keySet()) {
                    float prio;
                    limit = resource.tag != null && resource.tag.func_74764_b("pressurized") || this.pipe.canOutputPressurized(output.containingTile, false) ? 1000 : 50;
                    tileSpecificAcceptedFluid = Math.min(limit, canAccept);
                    int amount = (int)((float)tileSpecificAcceptedFluid * (prio = (float)((Integer)sorting.get(output)).intValue() / (float)sum));
                    int r = output.output.fill(Utils.copyFluidStackWithAmount(resource, amount, true), doFill);
                    if (r > 50) {
                        this.pipe.canOutputPressurized(output.containingTile, true);
                    }
                    f += r;
                    if ((canAccept -= r) > 0) continue;
                    break;
                }
                return f;
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

