/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPump;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockBottlingMachine;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityBottlingMachine
extends TileEntityMultiblockMetal<TileEntityBottlingMachine, IMultiblockRecipe>
implements ConveyorHandler.IConveyorAttachable {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000)};
    public List<BottlingProcess> bottlingProcessQueue = new ArrayList<BottlingProcess>();
    IItemHandler insertionHandler = new BottlingMachineInventoryHandler(this);

    public TileEntityBottlingMachine() {
        super(MultiblockBottlingMachine.instance, new int[]{3, 2, 3}, 16000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        NBTTagList processNBT = nbt.func_150295_c("bottlingQueue", 10);
        this.bottlingProcessQueue.clear();
        for (int i = 0; i < processNBT.func_74745_c(); ++i) {
            NBTTagCompound tag = processNBT.func_150305_b(i);
            BottlingProcess process = BottlingProcess.readFromNBT(tag);
            this.bottlingProcessQueue.add(process);
        }
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        NBTTagList processNBT = new NBTTagList();
        for (BottlingProcess process : this.bottlingProcessQueue) {
            processNBT.func_74742_a((NBTBase)process.writeToNBT());
        }
        nbt.func_74782_a("bottlingQueue", (NBTBase)processNBT);
        nbt.func_74782_a("tank", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.tickedProcesses = 0;
        int max = this.getMaxProcessPerTick();
        int i = 0;
        Iterator<BottlingProcess> processIterator = this.bottlingProcessQueue.iterator();
        this.tickedProcesses = 0;
        while (processIterator.hasNext() && i++ < max) {
            BottlingProcess process = processIterator.next();
            if (process.processStep(this)) {
                ++this.tickedProcesses;
            }
            if (!process.processFinished) continue;
            ItemStack output = process.items[1] != null ? process.items[1] : process.items[0];
            EnumFacing outDir = this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e();
            BlockPos outPos = this.getBlockPosForPos(8).func_177972_a(outDir);
            TileEntity inventoryTile = this.field_145850_b.func_175625_s(outPos);
            if (inventoryTile != null) {
                output = Utils.insertStackIntoInventory(inventoryTile, output, outDir.func_176734_d());
            }
            if (output != null) {
                Utils.dropStackAtPos(this.field_145850_b, outPos, output, outDir);
            }
            processIterator.remove();
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c == 4) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.field_174879_c < 6 || this.field_174879_c == 11) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.field_174879_c >= 6 && this.field_174879_c <= 8) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f};
        }
        if (this.field_174879_c == 9) {
            return new float[]{0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f};
        }
        if (this.field_174879_c == 10) {
            float xMax;
            float zMin;
            float xMin;
            EnumFacing f;
            EnumFacing enumFacing = f = this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e();
            float f2 = f == EnumFacing.EAST ? -0.0625f : (f == EnumFacing.WEST ? 0.25f : (this.facing == EnumFacing.WEST ? 0.125f : (xMin = this.facing == EnumFacing.EAST ? 0.25f : 0.0f)));
            float f3 = this.facing == EnumFacing.NORTH ? 0.125f : (this.facing == EnumFacing.SOUTH ? 0.25f : (f == EnumFacing.SOUTH ? -0.0625f : (zMin = f == EnumFacing.NORTH ? 0.25f : 0.0f)));
            float f4 = f == EnumFacing.EAST ? 0.75f : (f == EnumFacing.WEST ? 1.0625f : (this.facing == EnumFacing.WEST ? 0.75f : (xMax = this.facing == EnumFacing.EAST ? 0.875f : 1.0f)));
            float zMax = this.facing == EnumFacing.NORTH ? 0.75f : (this.facing == EnumFacing.SOUTH ? 0.875f : (f == EnumFacing.SOUTH ? 0.75f : (f == EnumFacing.NORTH ? 1.0625f : 1.0f)));
            return new float[]{xMin, 0.0625f, zMin, xMax, 0.6875f, zMax};
        }
        if (this.field_174879_c == 13) {
            float xMin = this.facing == EnumFacing.WEST ? 0.0f : 0.21875f;
            float zMin = this.facing == EnumFacing.NORTH ? 0.0f : 0.21875f;
            float xMax = this.facing == EnumFacing.EAST ? 1.0f : 0.78125f;
            float zMax = this.facing == EnumFacing.SOUTH ? 1.0f : 0.78125f;
            return new float[]{xMin, -0.4375f, zMin, xMax, 0.5625f, zMax};
        }
        if (this.field_174879_c == 16) {
            float xMax;
            float zMin;
            float xMin;
            float f = this.facing == EnumFacing.WEST ? 0.8125f : (xMin = this.facing == EnumFacing.EAST ? 0.0f : 0.125f);
            float f5 = this.facing == EnumFacing.NORTH ? 0.8125f : (zMin = this.facing == EnumFacing.SOUTH ? 0.0f : 0.125f);
            float f6 = this.facing == EnumFacing.WEST ? 1.0f : (xMax = this.facing == EnumFacing.EAST ? 0.1875f : 0.875f);
            float zMax = this.facing == EnumFacing.NORTH ? 1.0f : (this.facing == EnumFacing.SOUTH ? 0.1875f : 0.875f);
            return new float[]{xMin, -1.0f, zMin, xMax, 0.25f, zMax};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{11};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{1};
    }

    @Override
    public void replaceStructureBlock(BlockPos pos, IBlockState state, ItemStack stack, int h, int l, int w) {
        TileEntity tile;
        super.replaceStructureBlock(pos, state, stack, h, l, w);
        if (h == 2 && l == 1 && w == 1) {
            TileEntity tile2 = this.field_145850_b.func_175625_s(pos);
            if (tile2 instanceof TileEntityFluidPump) {
                ((TileEntityFluidPump)tile2).dummy = true;
            }
        } else if (h == 1 && l == 0 && (tile = this.field_145850_b.func_175625_s(pos)) instanceof TileEntityConveyorBelt) {
            ((TileEntityConveyorBelt)tile).setFacing(this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e());
        }
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (this.field_174879_c == 6 && !world.field_72995_K && entity != null && !entity.field_70128_L && entity instanceof EntityItem) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.master();
            if (master == null) {
                return;
            }
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            if (stack == null) {
                return;
            }
            if (master.bottlingProcessQueue.size() < master.getProcessQueueMaxLength()) {
                float dist = 1.0f;
                BottlingProcess p = null;
                if (master.bottlingProcessQueue.size() > 0 && (p = master.bottlingProcessQueue.get(master.bottlingProcessQueue.size() - 1)) != null) {
                    dist = (float)p.processTick / (float)p.maxProcessTick;
                }
                if (p != null && dist < master.getMinProcessDistance((TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe>)null)) {
                    return;
                }
                p = new BottlingProcess(Utils.copyStackWithAmount(stack, 1));
                master.bottlingProcessQueue.add(p);
                master.func_70296_d();
                master.markContainingBlockForUpdate(null);
                --stack.field_77994_a;
                if (stack.field_77994_a <= 0) {
                    entity.func_70106_y();
                }
            }
        }
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        EnumFacing outDir = this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e();
        BlockPos pos = this.func_174877_v().func_177967_a(outDir, 2);
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, outDir.func_176734_d());
        }
        if (output != null) {
            Utils.dropStackAtPos(this.field_145850_b, pos, output, outDir);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 2;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 2;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.5f;
    }

    @Override
    public ItemStack[] getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.master();
            if (master == null) {
                return false;
            }
            return this.field_174879_c == 6 && facing == (this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f());
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.master();
            if (master == null) {
                return null;
            }
            if (this.field_174879_c == 6 && facing == (this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f())) {
                return (T)master.insertionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.master();
        if (master != null && this.field_174879_c == 3 && (side == null || side.func_176740_k() != EnumFacing.Axis.Y)) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        if (this.field_174879_c == 3 && (side == null || side.func_176740_k() != EnumFacing.Axis.Y)) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.master();
            return master != null && master.tanks[iTank].getFluidAmount() < master.tanks[iTank].getCapacity();
        }
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public EnumFacing[] sigOutputDirections() {
        if (this.field_174879_c == 8) {
            return new EnumFacing[]{this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e()};
        }
        return new EnumFacing[0];
    }

    public static class BottlingMachineInventoryHandler
    implements IItemHandlerModifiable {
        TileEntityBottlingMachine multiblock;

        public BottlingMachineInventoryHandler(TileEntityBottlingMachine multiblock) {
            this.multiblock = multiblock;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return null;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.multiblock.bottlingProcessQueue.size() < this.multiblock.getProcessQueueMaxLength()) {
                stack = stack.func_77946_l();
                float dist = 1.0f;
                BottlingProcess p = null;
                if (this.multiblock.bottlingProcessQueue.size() > 0 && (p = this.multiblock.bottlingProcessQueue.get(this.multiblock.bottlingProcessQueue.size() - 1)) != null) {
                    dist = (float)p.processTick / (float)p.maxProcessTick;
                }
                if (p != null && dist < this.multiblock.getMinProcessDistance((TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe>)null)) {
                    return stack;
                }
                if (!simulate) {
                    p = new BottlingProcess(Utils.copyStackWithAmount(stack, 1));
                    this.multiblock.bottlingProcessQueue.add(p);
                    this.multiblock.func_70296_d();
                    this.multiblock.markContainingBlockForUpdate(null);
                }
                --stack.field_77994_a;
                if (stack.field_77994_a <= 0) {
                    stack = null;
                }
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return null;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }

    public static class BottlingProcess {
        public ItemStack[] items;
        public int processTick;
        public int maxProcessTick = (int)(120.0f * Config.IEConfig.Machines.bottlingMachine_timeModifier);
        boolean processFinished = false;

        public BottlingProcess(ItemStack input) {
            this.items = new ItemStack[]{input, null};
        }

        public boolean processStep(TileEntityBottlingMachine tile) {
            int energyExtracted = (int)(8.0f * Config.IEConfig.Machines.bottlingMachine_energyModifier);
            if (tile.energyStorage.extractEnergy(energyExtracted, true) >= energyExtracted) {
                FluidStack fs;
                tile.energyStorage.extractEnergy(energyExtracted, false);
                if (++this.processTick == (int)((double)this.maxProcessTick * 0.4375) && (fs = tile.tanks[0].getFluid()) != null) {
                    BottlingMachineRecipe recipe = BottlingMachineRecipe.findRecipe(this.items[0], fs);
                    if (recipe != null) {
                        if (tile.tanks[0].drainInternal((FluidStack)recipe.fluidInput, (boolean)false).amount == recipe.fluidInput.amount) {
                            this.items[1] = recipe.getActualItemOutputs(tile).get(0);
                            tile.tanks[0].drainInternal(recipe.fluidInput, true);
                        }
                    } else {
                        ItemStack ret = Utils.fillFluidContainer((IFluidHandler)tile.tanks[0], this.items[0], null, null);
                        if (ret != null) {
                            this.items[1] = ret;
                        }
                    }
                    if (this.items[1] == null) {
                        this.items[1] = this.items[0];
                    }
                }
                if (this.processTick >= this.maxProcessTick) {
                    this.processFinished = true;
                }
                return true;
            }
            return false;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.items[0] != null) {
                nbt.func_74782_a("input", (NBTBase)this.items[0].func_77955_b(new NBTTagCompound()));
            }
            if (this.items[1] != null) {
                nbt.func_74782_a("output", (NBTBase)this.items[1].func_77955_b(new NBTTagCompound()));
            }
            nbt.func_74768_a("processTick", this.processTick);
            return nbt;
        }

        public static BottlingProcess readFromNBT(NBTTagCompound nbt) {
            ItemStack input = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("input"));
            BottlingProcess process = new BottlingProcess(input);
            if (nbt.func_74764_b("output")) {
                process.items[1] = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("output"));
            }
            process.processTick = nbt.func_74762_e("processTick");
            return process;
        }
    }
}

