/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import mekanism.api.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.frequency.Frequency;
import mekanism.common.security.IOwnerItem;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityData;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;

public final class SecurityUtils {
    public static boolean canAccess(EntityPlayer player, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ISecurityItem) && stack.func_77973_b() instanceof IOwnerItem) {
            String owner = ((IOwnerItem)stack.func_77973_b()).getOwner(stack);
            return owner == null || owner.equals(player.func_70005_c_());
        }
        if (stack == null || !(stack.func_77973_b() instanceof ISecurityItem)) {
            return true;
        }
        ISecurityItem security = (ISecurityItem)stack.func_77973_b();
        if (MekanismUtils.isOp(player)) {
            return true;
        }
        return SecurityUtils.canAccess(security.getSecurity(stack), player.func_70005_c_(), security.getOwner(stack));
    }

    public static boolean canAccess(EntityPlayer player, TileEntity tile) {
        if (tile == null || !(tile instanceof ISecurityTile)) {
            return true;
        }
        ISecurityTile security = (ISecurityTile)tile;
        if (MekanismUtils.isOp(player)) {
            return true;
        }
        return SecurityUtils.canAccess(security.getSecurity().getMode(), player.func_70005_c_(), security.getSecurity().getOwner());
    }

    private static boolean canAccess(ISecurityTile.SecurityMode mode, String username, String owner) {
        if (owner == null || username.equals(owner)) {
            return true;
        }
        SecurityFrequency freq = SecurityUtils.getFrequency(owner);
        if (freq == null) {
            return true;
        }
        if (freq.override) {
            mode = freq.securityMode;
        }
        if (mode == ISecurityTile.SecurityMode.PUBLIC) {
            return true;
        }
        return mode == ISecurityTile.SecurityMode.TRUSTED && freq.trusted.contains(username);
    }

    public static SecurityFrequency getFrequency(String owner) {
        if (owner != null) {
            for (Frequency f : Mekanism.securityFrequencies.getFrequencies()) {
                if (!(f instanceof SecurityFrequency) || !f.owner.equals(owner)) continue;
                return (SecurityFrequency)f;
            }
        }
        return null;
    }

    public static String getOwnerDisplay(String user, String owner) {
        if (owner == null) {
            return (Object)((Object)EnumColor.RED) + LangUtils.localize("gui.noOwner");
        }
        return (Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.owner") + ": " + (Object)((Object)(user.equals(owner) ? EnumColor.BRIGHT_GREEN : EnumColor.RED)) + owner;
    }

    public static void displayNoAccess(EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.RED) + LangUtils.localize("gui.noAccessDesc")));
    }

    public static ISecurityTile.SecurityMode getSecurity(ISecurityTile security, Side side) {
        SecurityData data;
        if (side == Side.SERVER) {
            SecurityFrequency freq = security.getSecurity().getFrequency();
            if (freq != null && freq.override) {
                return freq.securityMode;
            }
        } else if (side == Side.CLIENT && (data = MekanismClient.clientSecurityMap.get(security.getSecurity().getOwner())) != null && data.override) {
            return data.mode;
        }
        return security.getSecurity().getMode();
    }

    public static String getSecurityDisplay(ItemStack stack, Side side) {
        ISecurityItem security = (ISecurityItem)stack.func_77973_b();
        ISecurityTile.SecurityMode mode = security.getSecurity(stack);
        if (security.getOwner(stack) != null) {
            SecurityData data;
            if (side == Side.SERVER) {
                SecurityFrequency freq = SecurityUtils.getFrequency(security.getOwner(stack));
                if (freq != null && freq.override) {
                    mode = freq.securityMode;
                }
            } else if (side == Side.CLIENT && (data = MekanismClient.clientSecurityMap.get(security.getOwner(stack))) != null && data.override) {
                mode = data.mode;
            }
        }
        return mode.getDisplay();
    }

    public static String getSecurityDisplay(TileEntity tile, Side side) {
        ISecurityTile security = (ISecurityTile)tile;
        ISecurityTile.SecurityMode mode = security.getSecurity().getMode();
        if (security.getSecurity().getOwner() != null) {
            SecurityData data;
            if (side == Side.SERVER) {
                SecurityFrequency freq = SecurityUtils.getFrequency(security.getSecurity().getOwner());
                if (freq != null && freq.override) {
                    mode = freq.securityMode;
                }
            } else if (side == Side.CLIENT && (data = MekanismClient.clientSecurityMap.get(security.getSecurity().getOwner())) != null && data.override) {
                mode = data.mode;
            }
        }
        return mode.getDisplay();
    }

    public static boolean isOverridden(ItemStack stack, Side side) {
        ISecurityItem security = (ISecurityItem)stack.func_77973_b();
        if (security.getOwner(stack) == null) {
            return false;
        }
        if (side == Side.SERVER) {
            SecurityFrequency freq = SecurityUtils.getFrequency(security.getOwner(stack));
            return freq != null && freq.override;
        }
        SecurityData data = MekanismClient.clientSecurityMap.get(security.getOwner(stack));
        return data != null && data.override;
    }

    public static boolean isOverridden(TileEntity tile, Side side) {
        ISecurityTile security = (ISecurityTile)tile;
        if (security.getSecurity().getOwner() == null) {
            return false;
        }
        if (side == Side.SERVER) {
            SecurityFrequency freq = SecurityUtils.getFrequency(security.getSecurity().getOwner());
            return freq != null && freq.override;
        }
        SecurityData data = MekanismClient.clientSecurityMap.get(security.getSecurity().getOwner());
        return data != null && data.override;
    }
}

