/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.util.ListUtils;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityNoisyElectricBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityChemicalWasher
extends TileEntityNoisyElectricBlock
implements IGasHandler,
ITubeConnection,
IRedstoneControl,
IFluidHandlerWrapper,
IUpgradeTile,
ISustainedData,
Upgrade.IUpgradeInfoHandler,
ITankManager,
ISecurityTile {
    public FluidTank fluidTank = new FluidTank(10000);
    public GasTank inputTank = new GasTank(10000);
    public GasTank outputTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public static final int MAX_FLUID = 10000;
    public static int WATER_USAGE = 5;
    public int updateDelay;
    public int gasOutput = 256;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public final double BASE_ENERGY_USAGE;
    public double energyPerTick = this.BASE_ENERGY_USAGE = MekanismConfig.usage.chemicalWasherUsage;
    public WasherRecipe cachedRecipe;
    public double clientEnergyUsed;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 4);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;

    public TileEntityChemicalWasher() {
        super("machine.washer", "ChemicalWasher", BlockStateMachine.MachineType.CHEMICAL_WASHER.baseEnergy);
        this.inventory = new ItemStack[5];
        this.upgradeComponent.setSupported(Upgrade.MUFFLING);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            WasherRecipe recipe;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(3, this);
            this.manageBuckets();
            if (this.inventory[2] != null && this.outputTank.getGas() != null) {
                this.outputTank.draw(GasTransmission.addGas(this.inventory[2], this.outputTank.getGas()), true);
            }
            if (this.canOperate(recipe = this.getRecipe()) && this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                int operations = this.operate(recipe);
                double prev = this.getEnergy();
                this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                this.clientEnergyUsed = prev - this.getEnergy();
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (this.outputTank.getGas() != null) {
                GasStack toSend = new GasStack(this.outputTank.getGas().getGas(), Math.min(this.outputTank.getStored(), this.gasOutput));
                this.outputTank.draw(GasTransmission.emit(toSend, this, ListUtils.asList(MekanismUtils.getRight(this.facing))), true);
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public WasherRecipe getRecipe() {
        GasInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((GasInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getChemicalWasherRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public GasInput getInput() {
        return new GasInput(this.inputTank.getGas());
    }

    public boolean canOperate(WasherRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inputTank, this.fluidTank, this.outputTank);
    }

    public int operate(WasherRecipe recipe) {
        int operations = this.getUpgradedUsage();
        recipe.operate(this.inputTank, this.fluidTank, this.outputTank, operations);
        return operations;
    }

    private void manageBuckets() {
        if (FluidContainerUtils.isFluidContainer(this.inventory[0])) {
            FluidContainerUtils.handleContainerItemEmpty(this, this.fluidTank, 0, 1, FluidContainerUtils.FluidChecker.check(FluidRegistry.WATER));
        }
    }

    public int getUpgradedUsage() {
        int possibleProcess = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        possibleProcess = Math.min(Math.min(this.inputTank.getStored(), this.outputTank.getNeeded()), possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return Math.min(this.fluidTank.getFluidAmount() / WATER_USAGE, possibleProcess);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.isActive = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.clientEnergyUsed = dataStream.readDouble();
            if (dataStream.readBoolean()) {
                this.fluidTank.setFluid(new FluidStack(FluidRegistry.getFluid((String)PacketHandler.readString(dataStream)), dataStream.readInt()));
            } else {
                this.fluidTank.setFluid(null);
            }
            if (dataStream.readBoolean()) {
                this.inputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.inputTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.outputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.outputTank.setGas(null);
            }
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        data.add(this.clientEnergyUsed);
        if (this.fluidTank.getFluid() != null) {
            data.add(true);
            data.add(FluidRegistry.getFluidName((FluidStack)this.fluidTank.getFluid()));
            data.add(this.fluidTank.getFluidAmount());
        } else {
            data.add(false);
        }
        if (this.inputTank.getGas() != null) {
            data.add(true);
            data.add(this.inputTank.getGas().getGas().getID());
            data.add(this.inputTank.getStored());
        } else {
            data.add(false);
        }
        if (this.outputTank.getGas() != null) {
            data.add(true);
            data.add(this.outputTank.getGas().getGas().getID());
            data.add(this.outputTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.fluidTank.readFromNBT(nbtTags.func_74775_l("leftTank"));
        this.inputTank.read(nbtTags.func_74775_l("rightTank"));
        this.outputTank.read(nbtTags.func_74775_l("centerTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74782_a("leftTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("rightTank", (NBTBase)this.inputTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("centerTank", (NBTBase)this.outputTank.write(new NBTTagCompound()));
        return nbtTags;
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public GasTank getTank(EnumFacing side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.inputTank;
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.outputTank;
        }
        return null;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return this.getTank(side) != null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (this.getTank(side) == this.inputTank) {
            return this.getTank(side).canReceive(type) && RecipeHandler.Recipe.CHEMICAL_WASHER.containsRecipe(type);
        }
        return false;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            return this.getTank(side).receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.getTank(side).draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.getTank(side) == this.outputTank && this.getTank(side).canDraw(type);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return FluidUtil.getFluidContained((ItemStack)itemstack) != null && FluidUtil.getFluidContained((ItemStack)itemstack).getFluid() == FluidRegistry.WATER;
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 1) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return new int[]{0};
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return new int[]{1};
        }
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return new int[2];
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper(this, side);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource.getFluid())) {
            return this.fluidTank.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return from == EnumFacing.UP && fluid == FluidRegistry.WATER;
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from == EnumFacing.UP) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "fluidTank", this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.inputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "inputTank", this.inputTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "outputTank", this.outputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "fluidTank")));
        this.inputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "inputTank")));
        this.outputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "outputTank")));
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case ENERGY: {
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.energyPerTick = MekanismUtils.getBaseEnergyPerTick(this, this.BASE_ENERGY_USAGE);
            }
        }
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank, this.inputTank, this.outputTank};
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

