/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasTank;
import mekanism.api.util.StackUtils;
import mekanism.common.recipe.inputs.MachineInput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AdvancedMachineInput
extends MachineInput<AdvancedMachineInput> {
    public ItemStack itemStack;
    public Gas gasType;

    public AdvancedMachineInput(ItemStack item, Gas gas) {
        this.itemStack = item;
        this.gasType = gas;
    }

    public AdvancedMachineInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.itemStack = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("input"));
        this.gasType = Gas.readFromNBT(nbtTags.func_74775_l("gasType"));
    }

    @Override
    public AdvancedMachineInput copy() {
        return new AdvancedMachineInput(this.itemStack.func_77946_l(), this.gasType);
    }

    @Override
    public boolean isValid() {
        return this.itemStack != null && this.gasType != null;
    }

    public boolean useItem(ItemStack[] inventory, int index, boolean deplete) {
        if (AdvancedMachineInput.inputContains(inventory[index], this.itemStack)) {
            if (deplete) {
                inventory[index] = StackUtils.subtract(inventory[index], this.itemStack);
            }
            return true;
        }
        return false;
    }

    public boolean useSecondary(GasTank gasTank, int amountToUse, boolean deplete) {
        if (gasTank.getGasType() == this.gasType && gasTank.getStored() >= amountToUse) {
            gasTank.draw(amountToUse, deplete);
            return true;
        }
        return false;
    }

    public boolean matches(AdvancedMachineInput input) {
        return StackUtils.equalsWildcard(this.itemStack, input.itemStack) && input.itemStack.field_77994_a >= this.itemStack.field_77994_a;
    }

    @Override
    public int hashIngredients() {
        return StackUtils.hashItemStack(this.itemStack) << 8 | this.gasType.getID();
    }

    @Override
    public boolean testEquality(AdvancedMachineInput other) {
        if (!this.isValid()) {
            return !other.isValid();
        }
        return StackUtils.equalsWildcardWithNBT(this.itemStack, other.itemStack) && this.gasType.getID() == other.gasType.getID();
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof AdvancedMachineInput;
    }
}

