/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ITierItem;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class ItemBlockGasTank
extends ItemBlock
implements IGasItem,
ISustainedInventory,
ITierItem,
ISecurityItem {
    public Block metaBlock;
    public int MAX_GAS = 96000;
    public static final int TRANSFER_RATE = 256;

    public ItemBlockGasTank(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public String func_77653_i(ItemStack itemstack) {
        return LangUtils.localize("tile.GasTank" + this.getBaseTier(itemstack).getSimpleName() + ".name");
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        boolean place = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state);
        if (place) {
            TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_175625_s(pos);
            tileEntity.tier = Tier.GasTankTier.values()[this.getBaseTier(stack).ordinal()];
            tileEntity.gasTank.setMaxGas(tileEntity.tier.storage);
            tileEntity.gasTank.setGas(this.getGas(stack));
            if (tileEntity instanceof ISecurityTile) {
                TileEntityGasTank security = tileEntity;
                security.getSecurity().setOwner(this.getOwner(stack));
                if (this.hasSecurity(stack)) {
                    security.getSecurity().setMode(this.getSecurity(stack));
                }
                if (this.getOwner(stack) == null) {
                    security.getSecurity().setOwner(player.func_70005_c_());
                }
            }
            if (tileEntity instanceof ISideConfiguration) {
                TileEntityGasTank config = tileEntity;
                if (ItemDataUtils.hasData(stack, "sideDataStored")) {
                    config.getConfig().read(ItemDataUtils.getDataMap(stack));
                    config.getEjector().read(ItemDataUtils.getDataMap(stack));
                }
            }
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            if (!world.field_72995_K) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(tileEntity)));
            }
        }
        return place;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (gasStack == null) {
            list.add((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.empty") + ".");
        } else {
            String amount = "" + (gasStack.amount == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(gasStack.amount));
            list.add((Object)((Object)EnumColor.ORANGE) + gasStack.getGas().getLocalizedName() + ": " + (Object)((Object)EnumColor.GREY) + amount);
        }
        int cap = Tier.GasTankTier.values()[this.getBaseTier((ItemStack)itemstack).ordinal()].storage;
        list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + (cap == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(cap)));
        if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
        } else {
            if (this.hasSecurity(itemstack)) {
                list.add(SecurityUtils.getOwnerDisplay(entityplayer.func_70005_c_(), this.getOwner(itemstack)));
                list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.security") + ": " + SecurityUtils.getSecurityDisplay(itemstack, Side.CLIENT));
                if (SecurityUtils.isOverridden(itemstack, Side.CLIENT)) {
                    list.add((Object)((Object)EnumColor.RED) + "(" + LangUtils.localize("gui.overridden") + ")");
                }
            }
            list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
        }
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        return GasStack.readFromNBT(ItemDataUtils.getCompound(itemstack, "stored"));
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (stack == null || stack.amount == 0) {
            ItemDataUtils.removeData(itemstack, "stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            ItemDataUtils.setCompound(itemstack, "stored", gasStack.write(new NBTTagCompound()));
        }
    }

    public ItemStack getEmptyItem(Tier.GasTankTier tier) {
        ItemStack empty = new ItemStack((Item)this);
        this.setBaseTier(empty, tier.getBaseTier());
        this.setGas(empty, null);
        return empty;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List<ItemStack> list) {
        for (Tier.GasTankTier tier : Tier.GasTankTier.values()) {
            ItemStack empty = new ItemStack((Item)this);
            this.setBaseTier(empty, tier.getBaseTier());
            list.add(empty);
        }
        if (MekanismConfig.general.prefilledGasTanks) {
            for (Gas type : GasRegistry.getRegisteredGasses()) {
                if (!type.isVisible()) continue;
                ItemStack filled = new ItemStack((Item)this);
                this.setBaseTier(filled, Tier.BaseTier.CREATIVE);
                this.setGas(filled, new GasStack(type, ((IGasItem)filled.func_77973_b()).getMaxGas(filled)));
                list.add(filled);
            }
        }
    }

    @Override
    public Tier.BaseTier getBaseTier(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return Tier.BaseTier.BASIC;
        }
        return Tier.BaseTier.values()[itemstack.func_77978_p().func_74762_e("tier")];
    }

    @Override
    public void setBaseTier(ItemStack itemstack, Tier.BaseTier tier) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("tier", tier.ordinal());
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return Tier.GasTankTier.values()[this.getBaseTier((ItemStack)itemstack).ordinal()].storage;
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return Tier.GasTankTier.values()[this.getBaseTier((ItemStack)itemstack).ordinal()].output;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        if (this.getBaseTier(itemstack) == Tier.BaseTier.CREATIVE) {
            this.setGas(itemstack, new GasStack(stack.getGas(), Integer.MAX_VALUE));
            return stack.amount;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        if (this.getGas(itemstack) == null) {
            return null;
        }
        Gas type = this.getGas(itemstack).getGas();
        int gasToUse = Math.min(this.getStored(itemstack), Math.min(this.getRate(itemstack), amount));
        if (this.getBaseTier(itemstack) != Tier.BaseTier.CREATIVE) {
            this.setGas(itemstack, new GasStack(type, this.getStored(itemstack) - gasToUse));
        }
        return new GasStack(type, gasToUse);
    }

    private int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) == null || this.getGas(itemstack).getGas() == type;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) != null && (type == null || this.getGas(itemstack).getGas() == type);
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemDataUtils.setList((ItemStack)data[0], "Items", nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            return ItemDataUtils.getList((ItemStack)data[0], "Items");
        }
        return null;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (this.getGas(stack) != null ? (double)this.getGas((ItemStack)stack).amount : 0.0) / (double)this.getMaxGas(stack);
    }

    @Override
    public String getOwner(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "owner")) {
            return ItemDataUtils.getString(stack, "owner");
        }
        return null;
    }

    @Override
    public void setOwner(ItemStack stack, String owner) {
        if (owner == null || owner.isEmpty()) {
            ItemDataUtils.removeData(stack, "owner");
            return;
        }
        ItemDataUtils.setString(stack, "owner", owner);
    }

    @Override
    public ISecurityTile.SecurityMode getSecurity(ItemStack stack) {
        return ISecurityTile.SecurityMode.values()[ItemDataUtils.getInt(stack, "security")];
    }

    @Override
    public void setSecurity(ItemStack stack, ISecurityTile.SecurityMode mode) {
        ItemDataUtils.setInt(stack, "security", mode.ordinal());
    }

    @Override
    public boolean hasSecurity(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return this.hasSecurity(stack);
    }
}

