/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.machine.MachineRecipeWrapper;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.util.MekanismUtils;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.util.ResourceLocation;

public class MachineRecipeCategory
extends BaseRecipeCategory {
    public IGuiHelper guiHelper;
    public IDrawable background;
    public BasicMachineRecipe tempRecipe;
    public ITickTimer timer;

    public MachineRecipeCategory(IGuiHelper helper, String name, String unlocalized, GuiProgress.ProgressBar progress) {
        super("mekanism:gui/GuiBasicMachine.png", name, unlocalized, progress);
        this.guiHelper = helper;
        this.timer = helper.createTickTimer(20, 20, false);
        this.background = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), 28, 16, 144, 54);
    }

    @Override
    public void addGuiElements() {
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 55, 16));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 55, 52).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT_LARGE, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 111, 30));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public double getLevel() {
                return 1.0;
            }
        }, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 164, 15));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return (double)MachineRecipeCategory.this.timer.getValue() / 20.0;
            }
        }, this.progressBar, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 77, 37));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper) {
        if (recipeWrapper instanceof MachineRecipeWrapper) {
            this.tempRecipe = ((MachineRecipeWrapper)recipeWrapper).recipe;
        }
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 27, 0);
        itemStacks.init(1, false, 87, 18);
        itemStacks.setFromRecipe(0, recipeWrapper.getInputs());
        itemStacks.setFromRecipe(1, recipeWrapper.getOutputs());
    }
}

