/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.redflux;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jotato.quantumflux.Logger;
import jotato.quantumflux.redflux.IRedfluxProvider;

public final class RedfluxField {
    private static Map<String, List<IRedfluxProvider>> quantumLinks = new HashMap<String, List<IRedfluxProvider>>();

    public static List<IRedfluxProvider> getLinks(String owner) {
        if (owner == null) {
            return new ArrayList<IRedfluxProvider>();
        }
        List<IRedfluxProvider> providers = quantumLinks.get(owner);
        if (providers == null) {
            providers = new ArrayList<IRedfluxProvider>();
        }
        return providers;
    }

    public static void registerLink(IRedfluxProvider item) {
        Logger.devLog("link " + item.toString() + " to " + item.getOwner(), new Object[0]);
        if (item.getOwner() != null) {
            if (!quantumLinks.containsKey(item.getOwner())) {
                quantumLinks.put(item.getOwner(), new ArrayList());
            }
            if (!quantumLinks.get(item.getOwner()).contains(item)) {
                quantumLinks.get(item.getOwner()).add(item);
            }
        }
    }

    public static void removeLink(IRedfluxProvider item) {
        Logger.devLog("remove link " + item.toString() + " to " + item.getOwner(), new Object[0]);
        if (item.getOwner() != null) {
            quantumLinks.get(item.getOwner()).remove(item);
        }
    }

    public static void purge() {
        quantumLinks.clear();
    }

    public static int requestEnergy(int value, boolean simulate, String owner) {
        int tosend = 0;
        List<IRedfluxProvider> links = RedfluxField.getLinks(owner);
        IRedfluxProvider link = null;
        for (int i = 0; !(i >= links.size() || (link = links.get(i)).canSend() && (tosend += link.requestEnergy(value - tosend, simulate)) >= value); ++i) {
        }
        return tosend;
    }
}

