/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.zpe;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.blocks.TileBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileZeroPointExtractor
extends TileBase
implements IEnergyProvider,
ITickable {
    private EnergyStorage energy = new EnergyStorage(ConfigMan.zpe_maxPowerGen, Integer.MAX_VALUE);

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energy.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.energy.readFromNBT(energyTag);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.energy.receiveEnergy(Math.max(ConfigMan.zpe_maxPowerGen - this.func_174877_v().func_177956_o(), 1), false);
        for (EnumFacing dir : EnumFacing.values()) {
            IEnergyReceiver receiver;
            BlockPos targetBlock = this.func_174877_v().func_177971_a(dir.func_176730_m());
            TileEntity tile = this.field_145850_b.func_175625_s(targetBlock);
            if (!(tile instanceof IEnergyReceiver) || !(receiver = (IEnergyReceiver)tile).canConnectEnergy(dir.func_176734_d())) continue;
            int tosend = this.energy.extractEnergy(ConfigMan.zpe_maxPowerGen, true);
            int used = ((IEnergyReceiver)tile).receiveEnergy(dir.func_176734_d(), tosend, false);
            if (used > 0) {
                this.func_70296_d();
            }
            this.energy.extractEnergy(used, false);
        }
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.energy.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }
}

