/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.gui.component;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.IFluidTank;
import net.shadowfacts.shadowmc.gui.component.GUIComponent;
import net.shadowfacts.shadowmc.util.Color;

public class GUIFluidIndicator
extends GUIComponent {
    private Color border = new Color(-13158601);
    private IFluidTank tank;

    public GUIFluidIndicator(int x, int y, int width, int height, IFluidTank tank) {
        super(x, y, width, height);
        this.tank = tank;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        this.drawRect(this.x, this.y, this.width, this.height, this.border);
        if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
            float level = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
            int height = this.height - 4;
            int filled = Math.min((int)(level * (float)height), height);
            this.bindTexture(TextureMap.field_110575_b);
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(this.tank.getFluid().getFluid().getStill(this.tank.getFluid()).toString());
            int x = this.x + 2;
            int y = this.y + (height - filled) + 2;
            float minU = sprite.func_94214_a(0.0);
            float minV = sprite.func_94207_b(0.0);
            float maxU = sprite.func_94214_a(16.0);
            float maxV = sprite.func_94207_b(16.0);
            for (int i = 0; i < filled / 16; ++i) {
                this.drawFluidQuad(x, y + i * 16, 16, 16, minU, minV, maxU, maxV);
            }
            if (filled % 16 != 0) {
                this.drawFluidQuad(x, y + filled - filled % 16, 16, filled % 16, minU, minV, maxU, sprite.func_94207_b((double)(filled % 16)));
            }
        }
    }

    private void drawFluidQuad(int x, int y, int width, int height, float minU, float minV, float maxU, float maxV) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)this.zLevel).func_187315_a((double)minU, (double)maxV).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.zLevel).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)this.zLevel).func_187315_a((double)maxU, (double)minV).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)this.zLevel).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public List<String> getTooltip() {
        if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
            return ImmutableList.of((Object)String.format("%s %d / %d mB", this.tank.getFluid().getLocalizedName(), this.tank.getFluidAmount(), this.tank.getCapacity()));
        }
        return ImmutableList.of((Object)I18n.func_135052_a((String)"shadowmc.gui.empty", (Object[])new Object[0]));
    }

    public void setBorder(Color border) {
        this.border = border;
    }
}

