/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.blueprints;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.imageio.ImageIO;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.IVoxelAccess;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.share.ShareWorldData;
import mod.chiselsandbits.voxelspace.IVoxelProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;

public class BlueprintData
implements Runnable,
IVoxelProvider {
    private long lastNeeded = this.getCurrentTime();
    private EnumLoadState state = EnumLoadState.LOADING;
    private URL url = null;
    private ShareWorldData data;

    public BlueprintData(String url) {
        try {
            if (url != null) {
                this.url = new URL(url);
                Thread t = new Thread(this);
                t.setName("Blueprint-" + url);
                t.start();
            }
        }
        catch (MalformedURLException e) {
            this.state = EnumLoadState.FAILED;
            Log.logError("Blueprint URL is invalid.", e);
        }
    }

    private long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public synchronized void updateTime() {
        this.lastNeeded = this.getCurrentTime();
    }

    public synchronized boolean isExpired() {
        return this.getCurrentTime() - this.lastNeeded > ChiselsAndBits.getConfig().blueprintExpireTime;
    }

    public synchronized EnumLoadState getState() {
        this.updateTime();
        return this.state;
    }

    public void setLocalSource(String string) throws MalformedURLException, UnsupportedEncodingException {
        this.url = new URL("file", ClientSide.instance.getLocalName(), 0, "/" + URLEncoder.encode(string, "UTF-8"));
    }

    public void setURLSource(URL url2) {
        this.url = url2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(InputStream is) throws IOException {
        is = new BufferedInputStream(is);
        EnumLoadState result = EnumLoadState.FAILED;
        try {
            byte[] peek = new byte[4];
            is.mark(peek.length);
            is.read(peek);
            is.reset();
            if (peek[0] == 137 && peek[1] == 80 && peek[2] == 78 && peek[3] == 71) {
                this.data = new ShareWorldData(ImageIO.read(is));
            } else {
                StringBuilder builder = new StringBuilder();
                byte[] buffer = new byte[2048];
                int read = 0;
                do {
                    if ((read = is.read(buffer)) <= 0) continue;
                    builder.append(new String(buffer, 0, read, "ASCII"));
                } while (read > 0);
                this.data = new ShareWorldData(builder.toString());
            }
            result = EnumLoadState.LOADED;
        }
        finally {
            this.state = result;
        }
    }

    public void loadData(byte[] bs) throws IOException {
        EnumLoadState result = EnumLoadState.FAILED;
        try {
            this.data = new ShareWorldData(bs);
            result = EnumLoadState.LOADED;
        }
        finally {
            this.state = result;
        }
    }

    @Override
    public void run() {
        EnumLoadState result = EnumLoadState.FAILED;
        try {
            if (this.url.getProtocol().equals("file")) {
                if (this.url.getHost().equals(ClientSide.instance.getLocalName())) {
                    this.loadData(new FileInputStream(new File(URLDecoder.decode(this.url.getFile().substring(1), "UTF-8"))));
                    result = EnumLoadState.LOADED;
                    return;
                }
                return;
            }
            URLConnection src = this.url.openConnection();
            this.loadData(src.getInputStream());
            result = EnumLoadState.LOADED;
        }
        catch (IOException e) {
            Log.logError("Unload to download Blueprint.", e);
        }
        finally {
            this.state = result;
        }
    }

    public byte[] getStuctureData() throws IOException {
        return this.data.getStuctureData();
    }

    public int getXSize() {
        return this.data.getXSize();
    }

    public int getYSize() {
        return this.data.getYSize();
    }

    public int getZSize() {
        return this.data.getZSize();
    }

    public String getURL() {
        return this.url == null ? "" : this.url.toString();
    }

    @Override
    public IVoxelAccess get(int x, int y, int z) {
        return this.data.getBlob(x, y, z);
    }

    public IBlockState getStateAt(BlockPos p) {
        return this.data.getStateAt(p);
    }

    public TileEntityBlockChiseled getTileAt(BlockPos p) {
        return this.data.getTileAt(p);
    }

    public static enum EnumLoadState {
        LOADING,
        LOADED,
        FAILED;


        public boolean readyOrWaiting() {
            return this != FAILED;
        }
    }
}

