/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.painter;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ButtonEvent;
import mcjty.lib.gui.events.TextEvent;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.tools.MinecraftTools;
import mcjty.lib.varia.Counter;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.blocks.painter.EssencePainterContainer;
import mcjty.rftoolsdim.blocks.painter.EssencePainterTileEntity;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletObjectMapping;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.types.ControllerType;
import mcjty.rftoolsdim.dimensions.types.FeatureType;
import mcjty.rftoolsdim.dimensions.types.SpecialType;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import mcjty.rftoolsdim.items.ModItems;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class GuiEssencePainter
extends GenericGuiContainer<EssencePainterTileEntity> {
    public static final int PAINTER_WIDTH = 256;
    public static final int PAINTER_HEIGHT = 224;
    private Button extractButton;
    private Button storeButton;
    private TextField nameField;
    private Label validateField;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsdim", "textures/gui/essencepainter.png");

    public GuiEssencePainter(EssencePainterTileEntity tileEntity, EssencePainterContainer container) {
        super((ModBase)RFToolsDim.instance, RFToolsDimMessages.INSTANCE, (GenericTileEntity)tileEntity, (Container)container, RFToolsDim.GUI_MANUAL_DIMENSION, "enscriber");
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.extractButton = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Extract")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(13, 164, 60, 16))).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiEssencePainter.this.extractDimlets();
            }
        }).setTooltips(new String[]{"Extract the dimlets out of", "a realized dimension tab"});
        this.storeButton = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Store")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(13, 182, 60, 16))).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiEssencePainter.this.storeDimlets();
            }
        }).setTooltips(new String[]{"Store dimlets in a", "empty dimension tab"});
        this.nameField = (TextField)new TextField(this.field_146297_k, (Gui)this).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiEssencePainter.this.storeName(newText);
            }
        }).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(13, 200, 60, 16));
        this.validateField = new Label(this.field_146297_k, (Gui)this).setText("Val");
        this.validateField.setTooltips(new String[]{"Hover here for errors..."});
        this.validateField.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(35, 142, 38, 16));
        this.setNameFromDimensionTab();
        AbstractContainerWidget toplevel = ((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.extractButton)).addChild((Widget)this.storeButton)).addChild((Widget)this.nameField)).addChild((Widget)this.validateField);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void storeName(String name) {
        this.sendServerCommand(RFToolsDimMessages.INSTANCE, "setName", new Argument[]{new Argument("name", name)});
    }

    private void extractDimlets() {
        for (int i = 0; i < 91; ++i) {
            ItemStack stack = this.field_147002_h.func_75139_a(i + 0).func_75211_c();
            if (!ItemStackTools.isValid((ItemStack)stack)) continue;
            Logging.warn((EntityPlayer)MinecraftTools.getPlayer((Minecraft)this.field_146297_k), (String)"You cannot extract. Remove all dimlets first!");
            return;
        }
        this.sendServerCommand(RFToolsDimMessages.INSTANCE, "extract", new Argument[0]);
    }

    private void storeDimlets() {
        this.sendServerCommand(RFToolsDimMessages.INSTANCE, "store", new Argument[]{new Argument("name", this.nameField.getText())});
    }

    private void enableButtons() {
        Slot slot = this.field_147002_h.func_75139_a(91);
        this.extractButton.setEnabled(false);
        this.storeButton.setEnabled(false);
        if (ItemStackTools.isValid((ItemStack)slot.func_75211_c())) {
            if (slot.func_75211_c().func_77973_b() == ModItems.emptyDimensionTabItem) {
                this.storeButton.setEnabled(true);
            } else if (slot.func_75211_c().func_77973_b() == ModItems.realizedDimensionTabItem) {
                this.extractButton.setEnabled(true);
            }
        }
    }

    private List<DimletKey> extractModifiersForType(List<DimletKey> modifiers, DimletType type) {
        ArrayList<DimletKey> modifiersForType = new ArrayList<DimletKey>();
        int i = 0;
        while (i < modifiers.size()) {
            DimletKey modifier = modifiers.get(i);
            if (type.dimletType.isModifiedBy(modifier.getType())) {
                modifiersForType.add(modifier);
                modifiers.remove(i);
                continue;
            }
            ++i;
        }
        return modifiersForType;
    }

    private String shortenName(String name) {
        int idx = name.indexOf(95);
        if (idx == -1) {
            return name;
        }
        return name.substring(idx + 1);
    }

    private void validateDimlets() {
        ArrayList<String> tooltips = new ArrayList<String>();
        TerrainType terrainType = null;
        int cntTerrain = 0;
        int cntBiomes = 0;
        int cntController = 0;
        int cntOwner = 0;
        for (int i = 0; i < 91; ++i) {
            Slot slot = this.field_147002_h.func_75139_a(i);
            if (slot == null || !ItemStackTools.isValid((ItemStack)slot.func_75211_c())) continue;
            ItemStack stack = slot.func_75211_c();
            DimletKey key = KnownDimletConfiguration.getDimletKey(stack);
            if (key.getType() == DimletType.DIMLET_TERRAIN) {
                ++cntTerrain;
                terrainType = DimletObjectMapping.getTerrain(key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_BIOME) {
                ++cntBiomes;
                continue;
            }
            if (key.getType() == DimletType.DIMLET_CONTROLLER) {
                ++cntController;
                continue;
            }
            if (key.getType() != DimletType.DIMLET_SPECIAL || DimletObjectMapping.getSpecial(key) != SpecialType.SPECIAL_OWNER) continue;
            ++cntOwner;
        }
        if (cntOwner > 1) {
            tooltips.add("Using more then one owner dimlet is not useful!");
        }
        if (GeneralConfiguration.ownerDimletsNeeded && cntOwner != 1) {
            tooltips.add("You cannot make a dimension without an owner dimlet!");
            this.storeButton.setEnabled(false);
        }
        if (cntTerrain > 1) {
            tooltips.add("Using more then one TERRAIN is not useful!");
            terrainType = null;
        }
        if (cntController > 1) {
            tooltips.add("Using more then one CONTROLLER is not useful!");
        }
        ArrayList<DimletKey> modifiers = new ArrayList<DimletKey>();
        for (int i = 0; i < 91; ++i) {
            ControllerType controllerType;
            int neededBiomes;
            Slot slot = this.field_147002_h.func_75139_a(i);
            if (slot == null || !ItemStackTools.isValid((ItemStack)slot.func_75211_c())) continue;
            ItemStack stack = slot.func_75211_c();
            DimletKey key = KnownDimletConfiguration.getDimletKey(stack);
            DimletType type = key.getType();
            if (type.dimletType.isModifier()) {
                modifiers.add(key);
                continue;
            }
            List<DimletKey> modifiersForType = this.extractModifiersForType(modifiers, type);
            if (type == DimletType.DIMLET_TERRAIN) {
                if (DimletObjectMapping.getTerrain(key) != TerrainType.TERRAIN_VOID || modifiersForType.isEmpty()) continue;
                tooltips.add("VOID terrain cannot use modifiers");
                continue;
            }
            if (type == DimletType.DIMLET_FEATURE) {
                FeatureType featureType = DimletObjectMapping.getFeature(key);
                Counter modifierAmountUsed = new Counter();
                for (DimletKey modifier : modifiersForType) {
                    modifierAmountUsed.increment((Object)modifier.getType());
                }
                for (Map.Entry entry : modifierAmountUsed.entrySet()) {
                    Integer amountSupported = featureType.getSupportedModifierAmount((DimletType)((Object)entry.getKey()));
                    if (amountSupported == null) {
                        tooltips.add(this.shortenName(featureType.name()) + " does not use " + this.shortenName(((DimletType)((Object)entry.getKey())).name()) + " modifiers!");
                        continue;
                    }
                    if (amountSupported != 1 || (Integer)entry.getValue() <= 1) continue;
                    tooltips.add(this.shortenName(featureType.name()) + " only needs one " + this.shortenName(((DimletType)((Object)entry.getKey())).name()) + " modifier!");
                }
                if (terrainType == null && !featureType.supportsAllTerrains()) {
                    tooltips.add(this.shortenName(featureType.name()) + " is possibly useless as it does not work on all terrains!");
                }
                if (terrainType == null || featureType.isTerrainSupported(terrainType)) continue;
                tooltips.add(this.shortenName(featureType.name()) + " does not work for terrain " + this.shortenName(terrainType.name()) + "!");
                continue;
            }
            if (type != DimletType.DIMLET_CONTROLLER || (neededBiomes = (controllerType = DimletObjectMapping.getController(key)).getNeededBiomes()) == -1) continue;
            if (cntBiomes > neededBiomes) {
                tooltips.add("Too many biomes specified for " + this.shortenName(controllerType.name()) + "!");
                continue;
            }
            if (cntBiomes >= neededBiomes) continue;
            tooltips.add("Too few biomes specified for " + this.shortenName(controllerType.name()) + "!");
        }
        if (!modifiers.isEmpty()) {
            tooltips.add("There are dangling modifiers in this descriptor");
        }
        boolean error = true;
        if (tooltips.isEmpty()) {
            tooltips.add("Everything appears to be alright");
            error = false;
        }
        this.validateField.setTooltips(tooltips.toArray(new String[tooltips.size()]));
        this.validateField.setColor(error ? 0xFF0000 : 34816);
        this.validateField.setText(error ? "Warn" : "Ok");
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.enableButtons();
        this.validateDimlets();
        if (((EssencePainterTileEntity)this.tileEntity).hasTabSlotChangedAndClear()) {
            this.setNameFromDimensionTab();
        }
        this.drawWindow();
    }

    private void setNameFromDimensionTab() {
        String name;
        NBTTagCompound tagCompound;
        Slot slot = this.field_147002_h.func_75139_a(91);
        if (ItemStackTools.isValid((ItemStack)slot.func_75211_c()) && slot.func_75211_c().func_77973_b() == ModItems.realizedDimensionTabItem && (tagCompound = slot.func_75211_c().func_77978_p()) != null && (name = tagCompound.func_74779_i("name")) != null) {
            this.nameField.setText(name);
        }
    }
}

