/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickCollapseBlock
extends PieceTrick {
    SpellParam position;

    public PieceTrickCollapseBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", 2774482, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 80);
        meta.addStat(EnumSpellStat.COST, 125);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        if (context.caster.field_70170_p.field_72995_K) {
            return null;
        }
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        World world = context.caster.field_70170_p;
        BlockPos pos = new BlockPos(positionVal.x, positionVal.y, positionVal.z);
        BlockPos posDown = pos.func_177977_b();
        IBlockState state = world.func_180495_p(pos);
        IBlockState stateDown = world.func_180495_p(posDown);
        Block block = state.func_177230_c();
        Block blockBelow = stateDown.func_177230_c();
        if (!world.func_175660_a(context.caster, pos)) {
            return null;
        }
        if (blockBelow.isAir(stateDown, (IBlockAccess)world, posDown) && block.func_176195_g(state, world, pos) != -1.0f && ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)context.caster, (IBlockAccess)world, (BlockPos)pos) && world.func_175625_s(pos) == null && block.canSilkHarvest(world, pos, state, context.caster)) {
            if (state.func_177230_c() == Blocks.field_150439_ay) {
                state = Blocks.field_150450_ax.func_176223_P();
                world.func_175656_a(pos, state);
            }
            EntityFallingBlock falling = new EntityFallingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, state);
            world.func_72838_d((Entity)falling);
        }
        return null;
    }
}

