/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.texture;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.api.render.TextureInfo;
import team.chisel.client.render.Quad;
import team.chisel.client.render.ctm.ISubmap;
import team.chisel.client.render.ctx.CTMVBlockRenderContext;
import team.chisel.client.render.texture.AbstractChiselTexture;
import team.chisel.client.render.type.BlockRenderTypeCTMV;

public class ChiselTextureCTMV
extends AbstractChiselTexture<BlockRenderTypeCTMV> {
    public ChiselTextureCTMV(BlockRenderTypeCTMV type, TextureInfo info) {
        super(type, info);
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad quad, IBlockRenderContext context, int quadGoal) {
        if (context == null) {
            if (quad.func_178210_d() != null && quad.func_178210_d().func_176740_k().func_176720_b()) {
                return Lists.newArrayList((Object[])new BakedQuad[]{Quad.from(quad).transformUVs(this.sprites[0].getSprite()).setFullbright(this.fullbright).rebake()});
            }
            return Lists.newArrayList((Object[])new BakedQuad[]{Quad.from(quad).transformUVs(this.sprites[1].getSprite(), Quad.TOP_LEFT).setFullbright(this.fullbright).rebake()});
        }
        return Lists.newArrayList((Object[])new BakedQuad[]{this.getQuad(quad, ((CTMVBlockRenderContext)context).getData())});
    }

    private BakedQuad getQuad(BakedQuad in, CTMVBlockRenderContext.ConnectionData data) {
        boolean connected;
        Quad q = Quad.from(in).setFullbright(this.fullbright);
        CTMVBlockRenderContext.Connections cons = data.getConnections();
        EnumSet<EnumFacing> realConnections = EnumSet.copyOf(data.getConnections().getConnections());
        if (cons.connectedOr(EnumFacing.UP, EnumFacing.DOWN)) {
            realConnections.removeIf(f -> f.func_176740_k().func_176722_c());
        } else if (cons.connectedOr(EnumFacing.EAST, EnumFacing.WEST)) {
            realConnections.removeIf(f -> f == EnumFacing.NORTH || f == EnumFacing.SOUTH);
            realConnections.removeIf(f -> this.blockConnectionZ((EnumFacing)f, data));
        } else {
            realConnections.removeIf(f -> this.blockConnectionY((EnumFacing)f, data));
        }
        cons = new CTMVBlockRenderContext.Connections(realConnections);
        int rotation = 0;
        ISubmap uvs = Quad.TOP_LEFT;
        if (in.func_178210_d().func_176740_k().func_176722_c() && cons.connectedOr(EnumFacing.UP, EnumFacing.DOWN)) {
            uvs = this.getUVs(EnumFacing.UP, EnumFacing.DOWN, cons);
        } else if (cons.connectedOr(EnumFacing.EAST, EnumFacing.WEST)) {
            rotation = 1;
            uvs = this.getUVs(EnumFacing.EAST, EnumFacing.WEST, cons);
        } else if (cons.connectedOr(EnumFacing.NORTH, EnumFacing.SOUTH)) {
            uvs = this.getUVs(EnumFacing.NORTH, EnumFacing.SOUTH, cons);
            if (in.func_178210_d() == EnumFacing.DOWN) {
                rotation += 2;
            }
        }
        boolean bl = connected = !cons.getConnections().isEmpty();
        if (connected && !cons.connectedOr(EnumFacing.UP, EnumFacing.DOWN)) {
            if (in.func_178210_d() == EnumFacing.EAST) {
                ++rotation;
            }
            if (in.func_178210_d() == EnumFacing.NORTH) {
                rotation += 2;
            }
            if (in.func_178210_d() == EnumFacing.WEST) {
                rotation += 3;
            }
        }
        if (cons.connected(in.func_178210_d().func_176734_d())) {
            connected = false;
        }
        if (cons.getConnections().isEmpty() && in.func_178210_d().func_176740_k().func_176722_c()) {
            connected = true;
        }
        q = q.rotate(rotation);
        if (connected) {
            return q.transformUVs(this.sprites[1].getSprite(), uvs).rebake();
        }
        return q.transformUVs(this.sprites[0].getSprite()).rebake();
    }

    private ISubmap getUVs(EnumFacing face1, EnumFacing face2, CTMVBlockRenderContext.Connections cons) {
        ISubmap uvs = cons.connectedAnd(face1, face2) ? Quad.BOTTOM_LEFT : (cons.connected(face1) ? Quad.BOTTOM_RIGHT : Quad.TOP_RIGHT);
        return uvs;
    }

    private boolean blockConnectionY(EnumFacing dir, CTMVBlockRenderContext.ConnectionData data) {
        return this.blockConnection(dir, EnumFacing.Axis.Y, data) || this.blockConnection(dir, dir.func_176732_a(EnumFacing.Axis.Y).func_176740_k(), data);
    }

    private boolean blockConnectionZ(EnumFacing dir, CTMVBlockRenderContext.ConnectionData data) {
        return this.blockConnection(dir, EnumFacing.Axis.Z, data);
    }

    private boolean blockConnection(EnumFacing dir, EnumFacing.Axis axis, CTMVBlockRenderContext.ConnectionData data) {
        EnumFacing rot = dir.func_176732_a(axis);
        return data.getConnections(dir).connectedOr(rot, rot.func_176734_d());
    }
}

