/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.apache.commons.lang3.Validate;
import techreborn.client.TechRebornCreativeTab;
import techreborn.init.ModItems;

public class DynamicCell
extends Item {
    public static final int CAPACITY = 1000;

    public DynamicCell() {
        this.func_77637_a(TechRebornCreativeTab.instance);
        this.func_77655_b("techreborn.cell");
        this.func_77625_d(64);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && ((tag = stack.func_77978_p()).func_186856_d() != 1 || tag.func_74764_b("Fluid"))) {
            NBTTagCompound clearTag = new NBTTagCompound();
            clearTag.func_74782_a("Fluid", (NBTBase)tag.func_74775_l("Fluid"));
            stack.func_77982_d(clearTag);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            RayTraceResult result = this.func_77621_a(worldIn, playerIn, true);
            if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos pos = result.func_178782_a();
                IBlockState state = worldIn.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block instanceof IFluidBlock) {
                    FluidStack fluid;
                    IFluidBlock fluidBlock = (IFluidBlock)block;
                    if (fluidBlock.canDrain(worldIn, pos) && (fluid = fluidBlock.drain(worldIn, pos, false)) != null && fluid.amount == 1000 && this.tryAddCellToInventory(playerIn, stack, fluid.getFluid())) {
                        fluidBlock.drain(worldIn, pos, true);
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                } else if (block instanceof BlockStaticLiquid) {
                    Fluid fluid;
                    Fluid fluid2 = fluid = block.func_149688_o(state) == Material.field_151587_i ? FluidRegistry.LAVA : FluidRegistry.WATER;
                    if (this.tryAddCellToInventory(playerIn, stack, fluid)) {
                        if (fluid != FluidRegistry.WATER) {
                            worldIn.func_175698_g(pos);
                        }
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                }
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public boolean tryAddCellToInventory(EntityPlayer player, ItemStack stack, Fluid fluid) {
        if (player.field_71071_by.func_70441_a(DynamicCell.getCellWithFluid(fluid))) {
            --stack.field_77994_a;
            return true;
        }
        return false;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(DynamicCell.getEmptyCell(1));
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            subItems.add(DynamicCell.getCellWithFluid(fluid));
        }
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = DynamicCell.getFluidHandler(stack).getFluid();
        if (fluidStack == null) {
            return super.func_77653_i(stack);
        }
        return fluidStack.getLocalizedName() + " Cell";
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return DynamicCell.getFluidHandler(stack);
    }

    public static FluidHandler getFluidHandler(ItemStack stack) {
        return new FluidHandler(stack, 1000);
    }

    public static ItemStack getCellWithFluid(Fluid fluid, int stackSize) {
        Validate.notNull((Object)fluid);
        ItemStack stack = new ItemStack((Item)ModItems.CELL);
        DynamicCell.getFluidHandler(stack).fill(new FluidStack(fluid, 1000), true);
        stack.field_77994_a = stackSize;
        return stack;
    }

    public static ItemStack getEmptyCell(int amount) {
        return new ItemStack((Item)ModItems.CELL, amount);
    }

    public static ItemStack getCellWithFluid(Fluid fluid) {
        return DynamicCell.getCellWithFluid(fluid, 1);
    }

    public static class FluidHandler
    extends FluidHandlerItemStack {
        public FluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
            FluidStack stack;
            if (container.func_77942_o() && container.func_77978_p().func_74764_b("FluidName") && (stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p())) != null) {
                container.func_77982_d(new NBTTagCompound());
                this.fill(stack, true);
            }
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource.amount != this.capacity) {
                return 0;
            }
            return super.fill(resource, doFill);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain != this.capacity) {
                return null;
            }
            return super.drain(maxDrain, doDrain);
        }
    }
}

