/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.implosionCompressor;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.translation.I18n;
import techreborn.client.gui.GuiImplosionCompressor;
import techreborn.compat.jei.RecipeUtil;
import techreborn.compat.jei.implosionCompressor.ImplosionCompressorRecipeWrapper;

public class ImplosionCompressorRecipeCategory
extends BlankRecipeCategory<ImplosionCompressorRecipeWrapper> {
    private static final int[] INPUT_SLOTS = new int[]{0, 1};
    private static final int[] OUTPUT_SLOTS = new int[]{2, 3};
    private final IDrawable background;
    private final IDrawable electricity;
    private final String title;

    public ImplosionCompressorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiImplosionCompressor.texture, 16, 25, 116, 36);
        IDrawableStatic electricityDrawable = guiHelper.createDrawable(GuiImplosionCompressor.texture, 176, 0, 14, 14);
        this.electricity = guiHelper.createAnimatedDrawable(electricityDrawable, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.title = I18n.func_74838_a((String)"tile.techreborn.implosioncompressor.name");
    }

    @Nonnull
    public String getUid() {
        return "TechReborn.ImplosionCompressor";
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.electricity.draw(minecraft, 0, 12);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull ImplosionCompressorRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(INPUT_SLOTS[0], true, 20, 0);
        guiItemStacks.init(INPUT_SLOTS[1], true, 20, 18);
        guiItemStacks.init(OUTPUT_SLOTS[0], false, 76, 9);
        guiItemStacks.init(OUTPUT_SLOTS[1], false, 94, 9);
        RecipeUtil.setRecipeItems(recipeLayout, ingredients, INPUT_SLOTS, OUTPUT_SLOTS, null, null);
    }
}

