/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.container.builder;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import org.apache.commons.lang3.Range;
import reborncore.client.gui.slots.BaseSlot;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.client.container.builder.slot.FilteredSlot;

public final class ContainerPlayerInventoryBuilder {
    private final InventoryPlayer player;
    private final ContainerBuilder parent;
    private Range<Integer> main;
    private Range<Integer> hotbar;
    private Range<Integer> armor;

    ContainerPlayerInventoryBuilder(ContainerBuilder parent, InventoryPlayer player) {
        this.player = player;
        this.parent = parent;
    }

    public ContainerPlayerInventoryBuilder inventory(int xStart, int yStart) {
        int startIndex = this.parent.slots.size();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.parent.slots.add((Slot)new BaseSlot((IInventory)this.player, j + i * 9 + 9, xStart + j * 18, yStart + i * 18));
            }
        }
        this.main = Range.between((Comparable)Integer.valueOf(startIndex), (Comparable)Integer.valueOf(this.parent.slots.size() - 1));
        return this;
    }

    public ContainerPlayerInventoryBuilder hotbar(int xStart, int yStart) {
        int startIndex = this.parent.slots.size();
        for (int i = 0; i < 9; ++i) {
            this.parent.slots.add((Slot)new BaseSlot((IInventory)this.player, i, xStart + i * 18, yStart));
        }
        this.hotbar = Range.between((Comparable)Integer.valueOf(startIndex), (Comparable)Integer.valueOf(this.parent.slots.size() - 1));
        return this;
    }

    public ContainerPlayerInventoryBuilder inventory() {
        return this.inventory(8, 94);
    }

    public ContainerPlayerInventoryBuilder hotbar() {
        return this.hotbar(8, 152);
    }

    public ContainerPlayerArmorInventoryBuilder armor() {
        return new ContainerPlayerArmorInventoryBuilder(this);
    }

    public ContainerBuilder addInventory() {
        if (this.hotbar != null) {
            this.parent.addPlayerInventoryRange(this.hotbar);
        }
        if (this.main != null) {
            this.parent.addPlayerInventoryRange(this.main);
        }
        if (this.armor != null) {
            this.parent.addTileInventoryRange(this.armor);
        }
        return this.parent;
    }

    public static final class ContainerPlayerArmorInventoryBuilder {
        private final ContainerPlayerInventoryBuilder parent;
        private final int startIndex;

        public ContainerPlayerArmorInventoryBuilder(ContainerPlayerInventoryBuilder parent) {
            this.parent = parent;
            this.startIndex = ((ContainerPlayerInventoryBuilder)parent).parent.slots.size();
        }

        private ContainerPlayerArmorInventoryBuilder armor(int index, int xStart, int yStart, EntityEquipmentSlot slotType) {
            ((ContainerPlayerInventoryBuilder)this.parent).parent.slots.add(new FilteredSlot((IInventory)this.parent.player, index, xStart, yStart).setFilter(stack -> stack.func_77973_b().isValidArmor(stack, slotType, (Entity)((ContainerPlayerInventoryBuilder)this.parent).player.field_70458_d)));
            return this;
        }

        public ContainerPlayerArmorInventoryBuilder helmet(int xStart, int yStart) {
            return this.armor(this.parent.player.func_70302_i_() - 2, xStart, yStart, EntityEquipmentSlot.HEAD);
        }

        public ContainerPlayerArmorInventoryBuilder chestplate(int xStart, int yStart) {
            return this.armor(this.parent.player.func_70302_i_() - 3, xStart, yStart, EntityEquipmentSlot.CHEST);
        }

        public ContainerPlayerArmorInventoryBuilder leggings(int xStart, int yStart) {
            return this.armor(this.parent.player.func_70302_i_() - 4, xStart, yStart, EntityEquipmentSlot.LEGS);
        }

        public ContainerPlayerArmorInventoryBuilder boots(int xStart, int yStart) {
            return this.armor(this.parent.player.func_70302_i_() - 5, xStart, yStart, EntityEquipmentSlot.FEET);
        }

        public ContainerPlayerArmorInventoryBuilder complete(int xStart, int yStart) {
            return this.helmet(xStart, yStart).chestplate(xStart, yStart + 18).leggings(xStart, yStart + 18 + 18).boots(xStart, yStart + 18 + 18 + 18);
        }

        public ContainerPlayerInventoryBuilder addArmor() {
            this.parent.armor = Range.between((Comparable)Integer.valueOf(this.startIndex), (Comparable)Integer.valueOf(((ContainerPlayerInventoryBuilder)this.parent).parent.slots.size() - 1));
            return this.parent;
        }
    }
}

