/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.api.core.IToolPipette;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.farming.gui.ContainerFarm;
import forestry.greenhouse.gui.ContainerGreenhouse;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class TankWidget
extends Widget {
    private int overlayTexX = 176;
    private int overlayTexY = 0;
    private int slot = 0;
    protected boolean drawOverlay = true;

    public TankWidget(WidgetManager manager, int xPos, int yPos, int slot) {
        super(manager, xPos, yPos);
        this.slot = slot;
        this.height = 58;
    }

    public TankWidget setOverlayOrigin(int x, int y) {
        this.overlayTexX = x;
        this.overlayTexY = y;
        return this;
    }

    @Nullable
    public IFluidTank getTank() {
        Container container = this.manager.gui.field_147002_h;
        if (container instanceof IContainerLiquidTanks) {
            return ((IContainerLiquidTanks)container).getTank(this.slot);
        }
        if (container instanceof ContainerFarm) {
            return ((ContainerFarm)container).getTank(this.slot);
        }
        if (container instanceof ContainerGreenhouse) {
            return ((ContainerGreenhouse)container).getTank(this.slot);
        }
        return null;
    }

    @Override
    public void draw(int startX, int startY) {
        Fluid fluid;
        GlStateManager.func_179084_k();
        IFluidTank tank = this.getTank();
        if (tank == null || tank.getCapacity() <= 0) {
            return;
        }
        FluidStack contents = tank.getFluid();
        if (contents != null && contents.amount > 0 && contents.getFluid() != null && (fluid = contents.getFluid()) != null) {
            TextureMap textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
            ResourceLocation fluidStill = fluid.getStill();
            TextureAtlasSprite fluidStillSprite = null;
            if (fluidStill != null) {
                fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
            }
            if (fluidStillSprite == null) {
                fluidStillSprite = textureMapBlocks.func_174944_f();
            }
            int fluidColor = fluid.getColor(contents);
            int scaledAmount = contents.amount * this.height / tank.getCapacity();
            if (contents.amount > 0 && scaledAmount < 1) {
                scaledAmount = 1;
            }
            if (scaledAmount > this.height) {
                scaledAmount = this.height;
            }
            Proxies.render.bindTexture(TextureMap.field_110575_b);
            TankWidget.setGLColorFromInt(fluidColor);
            int xTileCount = this.width / 16;
            int xRemainder = this.width - xTileCount * 16;
            int yTileCount = scaledAmount / 16;
            int yRemainder = scaledAmount - yTileCount * 16;
            int yStart = startY + this.height;
            for (int xTile = 0; xTile <= xTileCount; ++xTile) {
                for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                    int width = xTile == xTileCount ? xRemainder : 16;
                    int height = yTile == yTileCount ? yRemainder : 16;
                    int x = startX + xTile * 16;
                    int y = yStart - (yTile + 1) * 16;
                    if (width <= 0 || height <= 0) continue;
                    int maskTop = 16 - height;
                    int maskRight = 16 - width;
                    TankWidget.drawFluidTexture(x + this.xPos, y + this.yPos, fluidStillSprite, maskTop, maskRight, 100.0);
                }
            }
        }
        if (this.drawOverlay) {
            GlStateManager.func_179097_i();
            Proxies.render.bindTexture(this.manager.gui.textureFile);
            this.manager.gui.func_73729_b(startX + this.xPos, startY + this.yPos, this.overlayTexX, this.overlayTexY, 16, 60);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        IFluidTank tank = this.getTank();
        if (!(tank instanceof StandardTank)) {
            return null;
        }
        return ((StandardTank)tank).getToolTip();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        vertexBuffer.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        EntityPlayerSP player = this.manager.minecraft.field_71439_g;
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.func_77973_b();
        Container container = this.manager.gui.field_147002_h;
        if (held instanceof IToolPipette && container instanceof IContainerLiquidTanks) {
            ((IContainerLiquidTanks)container).handlePipetteClickClient(this.slot, (EntityPlayer)player);
        }
    }
}

